/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linecorp.armeria.common.thrift.text.BaseContext;
import java.util.Iterator;
import java.util.Map;

class PairContext
extends BaseContext {
    private final Iterator<Map.Entry<String, JsonNode>> children;
    private boolean lhs;
    private Map.Entry<String, JsonNode> currentChild;

    protected PairContext(JsonNode json) {
        this.children = null != json ? json.fields() : null;
    }

    @Override
    protected void write() {
        this.lhs = !this.lhs;
    }

    @Override
    protected void read() {
        boolean bl = this.lhs = !this.lhs;
        if (this.isLhs()) {
            if (!this.children.hasNext()) {
                throw new RuntimeException("Called PairContext.read() too many times!");
            }
            this.currentChild = this.children.next();
        }
    }

    @Override
    protected JsonNode getCurrentChild() {
        if (this.lhs) {
            return new TextNode(this.currentChild.getKey());
        }
        return this.currentChild.getValue();
    }

    @Override
    protected boolean hasMoreChildren() {
        return this.children.hasNext();
    }

    protected boolean isLhs() {
        return this.lhs;
    }
}

