/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.google.common.base.MoreObjects;
import com.linecorp.armeria.internal.thrift.ThriftServiceMetadata;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ThriftServiceEntry {
    final String name;
    final Object implementation;
    final ThriftServiceMetadata metadata;

    ThriftServiceEntry(Map.Entry<String, ?> entry) {
        String name = entry.getKey();
        Object implementation = entry.getValue();
        Objects.requireNonNull(name, "implementations contains an entry with null key.");
        Objects.requireNonNull(implementation, "implementations['" + name + "']");
        this.name = name;
        this.implementation = implementation;
        this.metadata = new ThriftServiceMetadata(implementation);
    }

    public String name() {
        return this.name;
    }

    public Object implementation() {
        return this.implementation;
    }

    public Set<Class<?>> interfaces() {
        return this.metadata.interfaces();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Entry").add("name", (Object)this.name()).add("ifaces", this.interfaces()).add("impl", this.implementation()).toString();
    }
}

