/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.thrift.ThriftCall;
import com.linecorp.armeria.common.thrift.ThriftReply;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.server.logging.structured.StructuredLog;

public class ThriftStructuredLog
extends StructuredLog {
    private final String thriftServiceName;
    private final String thriftMethodName;
    private final ThriftCall thriftCall;
    private final ThriftReply thriftReply;

    ThriftStructuredLog(long timestampMillis, long responseTimeNanos, long requestSize, long responseSize, String thriftServiceName, String thriftMethodName, ThriftCall thriftCall, ThriftReply thriftReply) {
        super(timestampMillis, responseTimeNanos, requestSize, responseSize);
        this.thriftServiceName = thriftServiceName;
        this.thriftMethodName = thriftMethodName;
        this.thriftCall = thriftCall;
        this.thriftReply = thriftReply;
    }

    public ThriftStructuredLog(RequestLog reqLog) {
        super(reqLog);
        Object requestContent = reqLog.rawRequestContent();
        if (requestContent == null) {
            this.thriftServiceName = null;
            this.thriftMethodName = null;
            this.thriftCall = null;
            this.thriftReply = null;
            return;
        }
        if (!(requestContent instanceof ThriftCall)) {
            throw new IllegalArgumentException("expected ApacheThriftCall instance for RequestLog.requestContent() but was " + requestContent);
        }
        ThriftCall thriftCall = (ThriftCall)requestContent;
        String argsTypeName = thriftCall.args().getClass().getName();
        this.thriftServiceName = argsTypeName.substring(0, argsTypeName.indexOf(36));
        this.thriftMethodName = thriftCall.header().name;
        this.thriftCall = thriftCall;
        this.thriftReply = (ThriftReply)reqLog.rawResponseContent();
    }

    @JsonProperty
    public String thriftServiceName() {
        return this.thriftServiceName;
    }

    @JsonProperty
    public String thriftMethodName() {
        return this.thriftMethodName;
    }

    @JsonProperty
    public ThriftCall thriftCall() {
        return this.thriftCall;
    }

    @JsonProperty
    public ThriftReply thriftReply() {
        return this.thriftReply;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("timestamp", (Object)TextFormatter.epoch((long)this.timestampMillis())).add("responseTime", (Object)TextFormatter.elapsed((long)this.responseTimeNanos())).add("requestSize", (Object)TextFormatter.size((long)this.requestSize())).add("responseSize", (Object)TextFormatter.size((long)this.responseSize())).add("thriftServiceName", (Object)this.thriftServiceName).add("thriftMethodName", (Object)this.thriftMethodName).add("thriftCall", (Object)this.thriftCall).add("thriftReply", (Object)this.thriftReply).toString();
    }
}

