/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.thrift;

import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.internal.thrift.ThriftFieldAccess;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.thrift.AsyncProcessFunction;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;

public final class ThriftFunction {
    private final Object func;
    private final Type type;
    private final Class<?> serviceType;
    private final String name;
    private final TBase<?, ?> result;
    private final TFieldIdEnum[] argFields;
    private final TFieldIdEnum successField;
    private final Map<Class<Throwable>, TFieldIdEnum> exceptionFields;
    private final Class<?>[] declaredExceptions;

    ThriftFunction(Class<?> serviceType, ProcessFunction<?, ?> func) throws Exception {
        this(serviceType, func.getMethodName(), func, Type.SYNC, ThriftFunction.getArgFields(func), ThriftFunction.getResult(func), ThriftFunction.getDeclaredExceptions(func));
    }

    ThriftFunction(Class<?> serviceType, AsyncProcessFunction<?, ?, ?> func) throws Exception {
        this(serviceType, func.getMethodName(), func, Type.ASYNC, ThriftFunction.getArgFields(func), ThriftFunction.getResult(func), ThriftFunction.getDeclaredExceptions(func));
    }

    private ThriftFunction(Class<?> serviceType, String name, Object func, Type type, TFieldIdEnum[] argFields, TBase<?, ?> result, Class<?>[] declaredExceptions) throws Exception {
        this.func = func;
        this.type = type;
        this.serviceType = serviceType;
        this.name = name;
        this.argFields = argFields;
        this.result = result;
        this.declaredExceptions = declaredExceptions;
        ImmutableMap.Builder exceptionFieldsBuilder = ImmutableMap.builder();
        TFieldIdEnum successField = null;
        if (result != null) {
            Class<?> resultType = result.getClass();
            Map metaDataMap = FieldMetaData.getStructMetaDataMap(resultType);
            for (Map.Entry e : metaDataMap.entrySet()) {
                TFieldIdEnum key = (TFieldIdEnum)e.getKey();
                String fieldName = key.getFieldName();
                if ("success".equals(fieldName)) {
                    successField = key;
                    continue;
                }
                Class<?> fieldType = resultType.getField(fieldName).getType();
                if (!Throwable.class.isAssignableFrom(fieldType)) continue;
                Class<?> exceptionFieldType = fieldType;
                exceptionFieldsBuilder.put(exceptionFieldType, (Object)key);
            }
        }
        this.successField = successField;
        this.exceptionFields = exceptionFieldsBuilder.build();
    }

    public boolean isOneWay() {
        return this.result == null;
    }

    public boolean isAsync() {
        return this.type == Type.ASYNC;
    }

    public byte messageType() {
        return this.isOneWay() ? (byte)4 : 1;
    }

    public ProcessFunction<Object, TBase<?, ?>> syncFunc() {
        return (ProcessFunction)this.func;
    }

    public AsyncProcessFunction<Object, TBase<?, ?>, Object> asyncFunc() {
        return (AsyncProcessFunction)this.func;
    }

    public Class<?> serviceType() {
        return this.serviceType;
    }

    public String name() {
        return this.name;
    }

    public TFieldIdEnum successField() {
        return this.successField;
    }

    public Collection<TFieldIdEnum> exceptionFields() {
        return this.exceptionFields.values();
    }

    public Class<?>[] declaredExceptions() {
        return this.declaredExceptions;
    }

    public TBase<?, ?> newArgs() {
        if (this.isAsync()) {
            return (TBase)this.asyncFunc().getEmptyArgsInstance();
        }
        return this.syncFunc().getEmptyArgsInstance();
    }

    public TBase<?, ?> newArgs(List<Object> args) {
        Objects.requireNonNull(args, "args");
        TBase<?, ?> newArgs = this.newArgs();
        int size = args.size();
        for (int i = 0; i < size; ++i) {
            ThriftFieldAccess.set(newArgs, this.argFields[i], args.get(i));
        }
        return newArgs;
    }

    public TBase<?, ?> newResult() {
        return this.result.deepCopy();
    }

    public void setSuccess(TBase<?, ?> result, Object value) {
        if (this.successField != null) {
            ThriftFieldAccess.set(result, this.successField, value);
        }
    }

    public Object getResult(TBase<?, ?> result) throws TException {
        for (TFieldIdEnum fieldIdEnum : this.exceptionFields()) {
            if (!ThriftFieldAccess.isSet(result, fieldIdEnum)) continue;
            throw (TException)((Object)ThriftFieldAccess.get(result, fieldIdEnum));
        }
        TFieldIdEnum successField = this.successField();
        if (successField == null) {
            return null;
        }
        if (ThriftFieldAccess.isSet(result, successField)) {
            return ThriftFieldAccess.get(result, successField);
        }
        throw new TApplicationException(5, result.getClass().getName() + '.' + successField.getFieldName());
    }

    private static TBase<?, ?> getResult(ProcessFunction<?, ?> func) {
        return ThriftFunction.getResult0(Type.SYNC, func.getClass(), func.getMethodName());
    }

    private static TBase<?, ?> getResult(AsyncProcessFunction<?, ?, ?> asyncFunc) {
        return ThriftFunction.getResult0(Type.ASYNC, asyncFunc.getClass(), asyncFunc.getMethodName());
    }

    private static TBase<?, ?> getResult0(Type type, Class<?> funcClass, String methodName) {
        String resultTypeName = ThriftFunction.typeName(type, funcClass, methodName, methodName + "_result");
        try {
            Class<?> resultType = Class.forName(resultTypeName, false, funcClass.getClassLoader());
            return (TBase)resultType.newInstance();
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot determine the result type of method: " + methodName, e);
        }
    }

    public boolean setException(TBase<?, ?> result, Throwable cause) {
        Class<?> causeType = cause.getClass();
        for (Map.Entry<Class<Throwable>, TFieldIdEnum> e : this.exceptionFields.entrySet()) {
            if (!e.getKey().isAssignableFrom(causeType)) continue;
            ThriftFieldAccess.set(result, e.getValue(), cause);
            return true;
        }
        return false;
    }

    private static TBase<?, ?> getArgs(ProcessFunction<?, ?> func) {
        return ThriftFunction.getArgs0(Type.SYNC, func.getClass(), func.getMethodName());
    }

    private static TBase<?, ?> getArgs(AsyncProcessFunction<?, ?, ?> asyncFunc) {
        return ThriftFunction.getArgs0(Type.ASYNC, asyncFunc.getClass(), asyncFunc.getMethodName());
    }

    private static TBase<?, ?> getArgs0(Type type, Class<?> funcClass, String methodName) {
        String argsTypeName = ThriftFunction.typeName(type, funcClass, methodName, methodName + "_args");
        try {
            Class<?> argsType = Class.forName(argsTypeName, false, funcClass.getClassLoader());
            return (TBase)argsType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot determine the args class of method: " + methodName, e);
        }
    }

    private static TFieldIdEnum[] getArgFields(ProcessFunction<?, ?> func) {
        return ThriftFunction.getArgFields0(Type.SYNC, func.getClass(), func.getMethodName());
    }

    private static TFieldIdEnum[] getArgFields(AsyncProcessFunction<?, ?, ?> asyncFunc) {
        return ThriftFunction.getArgFields0(Type.ASYNC, asyncFunc.getClass(), asyncFunc.getMethodName());
    }

    private static TFieldIdEnum[] getArgFields0(Type type, Class<?> funcClass, String methodName) {
        String fieldIdEnumTypeName = ThriftFunction.typeName(type, funcClass, methodName, methodName + "_args$_Fields");
        try {
            Class<?> fieldIdEnumType = Class.forName(fieldIdEnumTypeName, false, funcClass.getClassLoader());
            return (TFieldIdEnum[])Objects.requireNonNull(fieldIdEnumType.getEnumConstants(), "field enum may not be empty");
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot determine the arg fields of method: " + methodName, e);
        }
    }

    private static Class<?>[] getDeclaredExceptions(ProcessFunction<?, ?> func) {
        return ThriftFunction.getDeclaredExceptions0(Type.SYNC, func.getClass(), func.getMethodName());
    }

    private static Class<?>[] getDeclaredExceptions(AsyncProcessFunction<?, ?, ?> asyncFunc) {
        return ThriftFunction.getDeclaredExceptions0(Type.ASYNC, asyncFunc.getClass(), asyncFunc.getMethodName());
    }

    private static Class<?>[] getDeclaredExceptions0(Type type, Class<?> funcClass, String methodName) {
        String ifaceTypeName = ThriftFunction.typeName(type, funcClass, methodName, "Iface");
        try {
            Class<?> ifaceType = Class.forName(ifaceTypeName, false, funcClass.getClassLoader());
            for (Method m : ifaceType.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                return m.getExceptionTypes();
            }
            throw new IllegalStateException("failed to find a method: " + methodName);
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot determine the declared exceptions of method: " + methodName, e);
        }
    }

    private static String typeName(Type type, Class<?> funcClass, String methodName, String toAppend) {
        String funcClassName = funcClass.getName();
        int serviceClassEndPos = funcClassName.lastIndexOf((type == Type.SYNC ? "$Processor$" : "$AsyncProcessor$") + methodName);
        if (serviceClassEndPos <= 0) {
            throw new IllegalStateException("cannot determine the service class of method: " + methodName);
        }
        return funcClassName.substring(0, serviceClassEndPos) + '$' + toAppend;
    }

    private static enum Type {
        SYNC,
        ASYNC;

    }
}

