/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.google.common.base.MoreObjects;
import com.linecorp.armeria.common.thrift.ThriftMessage;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TMessage;

public final class ThriftReply
extends ThriftMessage {
    @Nullable
    private final TBase<?, ?> result;
    @Nullable
    private final TApplicationException exception;

    public ThriftReply(TMessage header, TBase<?, ?> result) {
        super(header);
        if (header.type != 2) {
            throw new IllegalArgumentException("header.type: " + ThriftReply.typeStr(header.type) + " (expected: REPLY)");
        }
        this.result = Objects.requireNonNull(result, "result");
        this.exception = null;
    }

    public ThriftReply(TMessage header, TApplicationException exception) {
        super(header);
        if (header.type != 3) {
            throw new IllegalArgumentException("header.type: " + ThriftReply.typeStr(header.type) + " (expected: EXCEPTION)");
        }
        this.result = null;
        this.exception = Objects.requireNonNull(exception, "exception");
    }

    public boolean isException() {
        return this.exception != null;
    }

    public TBase<?, ?> result() {
        if (this.isException()) {
            throw new IllegalStateException("not a reply but an exception");
        }
        return this.result;
    }

    public TApplicationException exception() {
        if (!this.isException()) {
            throw new IllegalStateException("not an exception but a reply");
        }
        return this.exception;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftReply that = (ThriftReply)o;
        return super.equals(that) && Objects.equals(this.result, that.result) && Objects.equals(this.exception, that.exception);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + Objects.hashCode(this.result)) * 31 + Objects.hashCode(this.exception);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("seqId", this.header().seqid).add("type", (Object)this.typeStr()).add("name", (Object)this.header().name);
        if (this.result != null) {
            helper.add("result", this.result);
        } else {
            helper.add("exception", (Object)this.exception);
        }
        return helper.toString();
    }
}

