/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.linecorp.armeria.common.thrift.ThriftCall;
import com.linecorp.armeria.common.thrift.ThriftReply;
import com.linecorp.armeria.common.thrift.text.TTextProtocol;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TTransport;

public final class ThriftStructuredLogJsonFormat {
    public static ObjectMapper newObjectMapper(SimpleModule ... userModules) {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(TMessage.class, (JsonSerializer)new TMessageSerializer());
        module.addSerializer(TBase.class, (JsonSerializer)new TBaseSerializer());
        module.addSerializer(TApplicationException.class, (JsonSerializer)new TApplicationExceptionSerializer());
        module.addSerializer(ThriftCall.class, (JsonSerializer)new ThriftCallSerializer());
        module.addSerializer(ThriftReply.class, (JsonSerializer)new ThriftReplySerializer());
        objectMapper.registerModule((Module)module);
        for (SimpleModule userModule : userModules) {
            objectMapper.registerModule((Module)userModule);
        }
        return objectMapper;
    }

    private static String writeThriftObjectAsTText(Consumer<TProtocol> writer) {
        TMemoryBuffer buffer = new TMemoryBuffer(1024);
        TProtocol protocol = new TTextProtocol.Factory().getProtocol((TTransport)buffer);
        writer.accept(protocol);
        return new String(buffer.getArray(), 0, buffer.length());
    }

    private ThriftStructuredLogJsonFormat() {
    }

    private static class ThriftReplySerializer
    extends StdSerializer<ThriftReply> {
        private static final long serialVersionUID = -783551224966265113L;

        ThriftReplySerializer() {
            super(ThriftReply.class);
        }

        public void serialize(ThriftReply value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            TApplicationException exception;
            TBase<?, ?> result;
            if (value == null) {
                gen.writeNull();
                return;
            }
            gen.writeStartObject();
            gen.writeObjectField("header", (Object)value.header());
            if (value.isException()) {
                result = null;
                exception = value.exception();
            } else {
                result = value.result();
                exception = null;
            }
            gen.writeObjectField("result", result);
            gen.writeObjectField("exception", (Object)exception);
            gen.writeEndObject();
        }
    }

    private static class ThriftCallSerializer
    extends StdSerializer<ThriftCall> {
        private static final long serialVersionUID = -4873295256482417316L;

        ThriftCallSerializer() {
            super(ThriftCall.class);
        }

        public void serialize(ThriftCall value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("header", (Object)value.header());
            gen.writeObjectField("args", value.args());
            gen.writeEndObject();
        }
    }

    private static class TApplicationExceptionSerializer
    extends StdSerializer<TApplicationException> {
        private static final long serialVersionUID = -7552338111791933510L;

        TApplicationExceptionSerializer() {
            super(TApplicationException.class);
        }

        public void serialize(TApplicationException value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeRawValue(ThriftStructuredLogJsonFormat.writeThriftObjectAsTText(protocol -> {
                try {
                    value.write(protocol);
                }
                catch (TException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }));
        }
    }

    private static class TBaseSerializer
    extends StdSerializer<TBase> {
        private static final long serialVersionUID = -7954242119098597530L;

        TBaseSerializer() {
            super(TBase.class);
        }

        public void serialize(TBase value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeRawValue(ThriftStructuredLogJsonFormat.writeThriftObjectAsTText(protocol -> {
                try {
                    value.write(protocol);
                }
                catch (TException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }));
        }
    }

    private static class TMessageSerializer
    extends StdSerializer<TMessage> {
        private static final long serialVersionUID = 9105150745657053783L;

        protected TMessageSerializer() {
            super(TMessage.class);
        }

        public void serialize(TMessage value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("name", value.name);
            gen.writeNumberField("type", (int)value.type);
            gen.writeNumberField("seqid", value.seqid);
            gen.writeEndObject();
        }
    }
}

