/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.thrift;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.thrift.THttpClient;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

final class THttpClientInvocationHandler
implements InvocationHandler,
ClientBuilderParams {
    private static final Object[] NO_ARGS = new Object[0];
    private final ClientBuilderParams params;
    private final THttpClient thriftClient;
    private final String path;
    @Nullable
    private final String fragment;

    THttpClientInvocationHandler(ClientBuilderParams params, THttpClient thriftClient, String path, @Nullable String fragment) {
        this.params = params;
        this.thriftClient = thriftClient;
        this.path = path;
        this.fragment = fragment;
    }

    public ClientFactory factory() {
        return this.params.factory();
    }

    public URI uri() {
        return this.params.uri();
    }

    public Class<?> clientType() {
        return this.params.clientType();
    }

    public ClientOptions options() {
        return this.params.options();
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        assert (declaringClass == this.params.clientType());
        return this.invokeClientMethod(method, args);
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        String methodName;
        switch (methodName = method.getName()) {
            case "toString": {
                return this.params.clientType().getSimpleName() + '(' + this.path + ')';
            }
            case "hashCode": {
                return System.identityHashCode(proxy);
            }
            case "equals": {
                return proxy == args[0];
            }
        }
        throw new Error("unknown method: " + methodName);
    }

    @Nullable
    private Object invokeClientMethod(Method method, @Nullable Object[] args) throws Throwable {
        AsyncMethodCallback callback;
        if (args == null) {
            args = NO_ARGS;
            callback = null;
        } else {
            int lastIdx = args.length - 1;
            if (args.length > 0 && args[lastIdx] instanceof AsyncMethodCallback) {
                AsyncMethodCallback lastArg;
                callback = lastArg = (AsyncMethodCallback)args[lastIdx];
                args = Arrays.copyOfRange(args, 0, lastIdx);
            } else {
                callback = null;
            }
        }
        try {
            RpcResponse reply = this.fragment != null ? this.thriftClient.executeMultiplexed(this.path, this.params.clientType(), this.fragment, method.getName(), args) : this.thriftClient.execute(this.path, this.params.clientType(), method.getName(), args);
            if (callback != null) {
                reply.handle(Functions.voidFunction((result, cause) -> {
                    if (cause == null) {
                        callback.onComplete(result);
                    } else {
                        THttpClientInvocationHandler.invokeOnError((AsyncMethodCallback<Object>)callback, cause);
                    }
                })).exceptionally(CompletionActions::log);
                return null;
            }
            try {
                return reply.get();
            }
            catch (ExecutionException e) {
                throw Exceptions.peel((Throwable)e);
            }
        }
        catch (Throwable cause2) {
            if (callback != null) {
                THttpClientInvocationHandler.invokeOnError(callback, cause2);
                return null;
            }
            throw cause2;
        }
    }

    private static void invokeOnError(AsyncMethodCallback<Object> callback, Throwable cause) {
        callback.onError(cause instanceof Exception ? (Exception)cause : new UndeclaredThrowableException(cause));
    }
}

