/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.google.common.collect.ImmutableSet;
import com.linecorp.armeria.common.SerializationFormat;
import java.util.Objects;
import java.util.Set;

public final class ThriftSerializationFormats {
    public static final SerializationFormat BINARY = SerializationFormat.of((String)"tbinary");
    public static final SerializationFormat COMPACT = SerializationFormat.of((String)"tcompact");
    public static final SerializationFormat JSON = SerializationFormat.of((String)"tjson");
    public static final SerializationFormat TEXT = SerializationFormat.of((String)"ttext");
    private static final Set<SerializationFormat> THRIFT_FORMATS = ImmutableSet.of((Object)BINARY, (Object)COMPACT, (Object)JSON, (Object)TEXT);

    public static Set<SerializationFormat> values() {
        return THRIFT_FORMATS;
    }

    public static boolean isThrift(SerializationFormat format) {
        return ThriftSerializationFormats.values().contains(Objects.requireNonNull(format, "format"));
    }

    private ThriftSerializationFormats() {
    }
}

