/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.thrift;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DecoratingClientFactory;
import com.linecorp.armeria.client.DefaultClientBuilderParams;
import com.linecorp.armeria.client.thrift.DefaultTHttpClient;
import com.linecorp.armeria.client.thrift.THttpClient;
import com.linecorp.armeria.client.thrift.THttpClientDelegate;
import com.linecorp.armeria.client.thrift.THttpClientInvocationHandler;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;

final class THttpClientFactory
extends DecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES;

    THttpClientFactory(ClientFactory httpClientFactory) {
        super(httpClientFactory);
    }

    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        Scheme scheme = this.validateScheme(uri);
        SerializationFormat serializationFormat = scheme.serializationFormat();
        Client delegate = options.decoration().decorate(RpcRequest.class, RpcResponse.class, (Client)new THttpClientDelegate(this.newHttpClient(uri, scheme, options), serializationFormat));
        if (clientType == THttpClient.class) {
            DefaultTHttpClient client = new DefaultTHttpClient((ClientBuilderParams)new DefaultClientBuilderParams((ClientFactory)this, uri, THttpClient.class, options), (Client<RpcRequest, RpcResponse>)delegate, this.meterRegistry(), scheme.sessionProtocol(), THttpClientFactory.newEndpoint((URI)uri));
            return (T)client;
        }
        DefaultTHttpClient thriftClient = new DefaultTHttpClient((ClientBuilderParams)new DefaultClientBuilderParams((ClientFactory)this, THttpClientFactory.pathlessUri(uri), THttpClient.class, options), (Client<RpcRequest, RpcResponse>)delegate, this.meterRegistry(), scheme.sessionProtocol(), THttpClientFactory.newEndpoint((URI)uri));
        Object client = Proxy.newProxyInstance(clientType.getClassLoader(), new Class[]{clientType}, (InvocationHandler)new THttpClientInvocationHandler((ClientBuilderParams)new DefaultClientBuilderParams((ClientFactory)this, uri, clientType, options), thriftClient, (String)MoreObjects.firstNonNull((Object)uri.getRawPath(), (Object)"/"), uri.getFragment()));
        return (T)client;
    }

    private Client<HttpRequest, HttpResponse> newHttpClient(URI uri, Scheme scheme, ClientOptions options) {
        try {
            Client client = (Client)this.delegate().newClient(new URI(Scheme.of((SerializationFormat)SerializationFormat.NONE, (SessionProtocol)scheme.sessionProtocol()).uriText(), uri.getRawAuthority(), null, null, null), Client.class, options);
            return client;
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    private static URI pathlessUri(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getRawAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SessionProtocol p : SessionProtocol.values()) {
            for (SerializationFormat f : ThriftSerializationFormats.values()) {
                builder.add((Object)Scheme.of((SerializationFormat)f, (SessionProtocol)p));
            }
        }
        SUPPORTED_SCHEMES = builder.build();
    }
}

