/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.thrift;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.InvalidResponseHeadersException;
import com.linecorp.armeria.common.DefaultRpcResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftCall;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactories;
import com.linecorp.armeria.common.thrift.ThriftReply;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.thrift.TApplicationExceptions;
import com.linecorp.armeria.internal.thrift.ThriftFieldAccess;
import com.linecorp.armeria.internal.thrift.ThriftFunction;
import com.linecorp.armeria.internal.thrift.ThriftServiceMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

final class THttpClientDelegate
implements Client<RpcRequest, RpcResponse> {
    private final AtomicInteger nextSeqId = new AtomicInteger();
    private final Client<HttpRequest, HttpResponse> httpClient;
    private final SerializationFormat serializationFormat;
    private final TProtocolFactory protocolFactory;
    private final MediaType mediaType;
    private final Map<Class<?>, ThriftServiceMetadata> metadataMap = new ConcurrentHashMap();

    THttpClientDelegate(Client<HttpRequest, HttpResponse> httpClient, SerializationFormat serializationFormat) {
        this.httpClient = httpClient;
        this.serializationFormat = serializationFormat;
        this.protocolFactory = ThriftProtocolFactories.get(serializationFormat);
        this.mediaType = serializationFormat.mediaType();
    }

    public RpcResponse execute(ClientRequestContext ctx, RpcRequest call) throws Exception {
        ThriftFunction func;
        int seqId = this.nextSeqId.incrementAndGet();
        String method = call.method();
        List args = call.params();
        DefaultRpcResponse reply = new DefaultRpcResponse();
        ctx.logBuilder().serializationFormat(this.serializationFormat);
        try {
            func = this.metadata(call.serviceType()).function(method);
            if (func == null) {
                throw new IllegalArgumentException("Thrift method not found: " + method);
            }
        }
        catch (Throwable cause2) {
            reply.completeExceptionally(cause2);
            return reply;
        }
        try {
            TMemoryBuffer outTransport = new TMemoryBuffer(128);
            TProtocol tProtocol = this.protocolFactory.getProtocol((TTransport)outTransport);
            TMessage header = new TMessage(THttpClientDelegate.fullMethod(ctx, method), func.messageType(), seqId);
            tProtocol.writeMessageBegin(header);
            TBase<?, ?> tArgs = func.newArgs(args);
            tArgs.write(tProtocol);
            tProtocol.writeMessageEnd();
            ctx.logBuilder().requestContent((Object)call, (Object)new ThriftCall(header, tArgs));
            HttpRequest httpReq = HttpRequest.of((RequestHeaders)RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)ctx.path(), (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.mediaType), (HttpData)HttpData.of((byte[])outTransport.getArray(), (int)0, (int)outTransport.length()));
            ctx.logBuilder().deferResponseContent();
            CompletableFuture future = ((HttpResponse)this.httpClient.execute(ctx, (Request)httpReq)).aggregate();
            ((CompletableFuture)future.handle((res, cause) -> {
                if (cause != null) {
                    THttpClientDelegate.handlePreDecodeException(ctx, reply, func, Exceptions.peel((Throwable)cause));
                    return null;
                }
                HttpStatus status = res.status();
                if (status.code() != HttpStatus.OK.code()) {
                    THttpClientDelegate.handlePreDecodeException(ctx, reply, func, (Throwable)new InvalidResponseHeadersException(ResponseHeaders.of((HttpHeaders)res.headers())));
                    return null;
                }
                try {
                    this.handle(ctx, seqId, reply, func, res.content());
                }
                catch (Throwable t) {
                    THttpClientDelegate.handlePreDecodeException(ctx, reply, func, t);
                }
                return null;
            })).exceptionally(CompletionActions::log);
        }
        catch (Throwable cause3) {
            THttpClientDelegate.handlePreDecodeException(ctx, reply, func, cause3);
        }
        return reply;
    }

    private static String fullMethod(ClientRequestContext ctx, String method) {
        String service = ctx.fragment();
        if (Strings.isNullOrEmpty((String)service)) {
            return method;
        }
        return service + ':' + method;
    }

    private ThriftServiceMetadata metadata(Class<?> serviceType) {
        ThriftServiceMetadata metadata = this.metadataMap.get(serviceType);
        if (metadata != null) {
            return metadata;
        }
        return this.metadataMap.computeIfAbsent(serviceType, ThriftServiceMetadata::new);
    }

    private void handle(ClientRequestContext ctx, int seqId, DefaultRpcResponse reply, ThriftFunction func, HttpData content) throws TException {
        TMessage header;
        if (func.isOneWay()) {
            THttpClientDelegate.handleSuccess(ctx, reply, null, null);
            return;
        }
        if (content.isEmpty()) {
            throw new TApplicationException(5);
        }
        TMemoryInputTransport inputTransport = new TMemoryInputTransport(content.array(), content.offset(), content.length());
        TProtocol inputProtocol = this.protocolFactory.getProtocol((TTransport)inputTransport);
        TApplicationException appEx = THttpClientDelegate.readApplicationException(seqId, func, inputProtocol, header = inputProtocol.readMessageBegin());
        if (appEx != null) {
            THttpClientDelegate.handleException(ctx, reply, new ThriftReply(header, appEx), (Exception)appEx);
            return;
        }
        TBase<?, ?> result = func.newResult();
        result.read(inputProtocol);
        inputProtocol.readMessageEnd();
        ThriftReply rawResponseContent = new ThriftReply(header, result);
        for (TFieldIdEnum fieldIdEnum : func.exceptionFields()) {
            if (!ThriftFieldAccess.isSet(result, fieldIdEnum)) continue;
            TException cause = (TException)ThriftFieldAccess.get(result, fieldIdEnum);
            THttpClientDelegate.handleException(ctx, reply, rawResponseContent, (Exception)cause);
            return;
        }
        TFieldIdEnum successField = func.successField();
        if (successField == null) {
            THttpClientDelegate.handleSuccess(ctx, reply, null, rawResponseContent);
            return;
        }
        if (ThriftFieldAccess.isSet(result, successField)) {
            Object returnValue = ThriftFieldAccess.get(result, successField);
            THttpClientDelegate.handleSuccess(ctx, reply, returnValue, rawResponseContent);
            return;
        }
        THttpClientDelegate.handleException(ctx, reply, rawResponseContent, (Exception)new TApplicationException(5, result.getClass().getName() + '.' + successField.getFieldName()));
    }

    @Nullable
    private static TApplicationException readApplicationException(int seqId, ThriftFunction func, TProtocol inputProtocol, TMessage msg) throws TException {
        if (msg.seqid != seqId) {
            throw new TApplicationException(4);
        }
        if (!func.name().equals(msg.name)) {
            return new TApplicationException(3, msg.name);
        }
        if (msg.type == 3) {
            TApplicationException appEx = TApplicationExceptions.read(inputProtocol);
            inputProtocol.readMessageEnd();
            return appEx;
        }
        return null;
    }

    private static void handleSuccess(ClientRequestContext ctx, DefaultRpcResponse reply, @Nullable Object returnValue, @Nullable ThriftReply rawResponseContent) {
        reply.complete(returnValue);
        ctx.logBuilder().responseContent((Object)reply, (Object)rawResponseContent);
    }

    private static void handleException(ClientRequestContext ctx, DefaultRpcResponse reply, @Nullable ThriftReply rawResponseContent, Exception cause) {
        reply.completeExceptionally((Throwable)cause);
        ctx.logBuilder().responseContent((Object)reply, (Object)rawResponseContent);
    }

    private static void handlePreDecodeException(ClientRequestContext ctx, DefaultRpcResponse reply, ThriftFunction thriftMethod, Throwable cause) {
        THttpClientDelegate.handleException(ctx, reply, null, THttpClientDelegate.decodeException(cause, thriftMethod.declaredExceptions()));
    }

    private static Exception decodeException(Throwable cause, @Nullable Class<?>[] declaredThrowableExceptions) {
        if (cause instanceof RuntimeException || cause instanceof TException) {
            return (Exception)cause;
        }
        boolean isDeclaredException = declaredThrowableExceptions != null ? Arrays.stream(declaredThrowableExceptions).anyMatch(v -> v.isInstance(cause)) : false;
        if (isDeclaredException) {
            return (Exception)cause;
        }
        if (cause instanceof Error) {
            return new RuntimeException(cause);
        }
        return new TTransportException(cause);
    }
}

