/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.thrift;

import com.linecorp.armeria.internal.Types;
import com.linecorp.armeria.internal.thrift.ThriftFunction;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.thrift.AsyncProcessFunction;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.TBaseProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftServiceMetadata {
    private static final Logger logger = LoggerFactory.getLogger(ThriftServiceMetadata.class);
    private final Set<Class<?>> interfaces;
    private final Map<String, ThriftFunction> functions = new HashMap<String, ThriftFunction>();

    public ThriftServiceMetadata(Object implementation) {
        Objects.requireNonNull(implementation, "implementation");
        this.interfaces = this.init(implementation);
    }

    public ThriftServiceMetadata(Class<?> serviceType) {
        Objects.requireNonNull(serviceType, "serviceType");
        this.interfaces = this.init(null, Collections.singleton(serviceType));
    }

    private Set<Class<?>> init(Object implementation) {
        return this.init(implementation, Types.getAllInterfaces(implementation.getClass()));
    }

    private Set<Class<?>> init(@Nullable Object implementation, Iterable<Class<?>> candidateInterfaces) {
        HashSet methodNames = new HashSet();
        HashSet interfaces = new HashSet();
        for (Class<?> iface : candidateInterfaces) {
            Map<String, ProcessFunction<?, ?>> processMap;
            Map<String, AsyncProcessFunction<?, ?, ?>> asyncProcessMap = ThriftServiceMetadata.getThriftAsyncProcessMap(implementation, iface);
            if (asyncProcessMap != null) {
                asyncProcessMap.forEach((name, func) -> this.registerFunction(methodNames, iface, (String)name, func));
                interfaces.add(iface);
            }
            if ((processMap = ThriftServiceMetadata.getThriftProcessMap(implementation, iface)) == null) continue;
            processMap.forEach((name, func) -> this.registerFunction(methodNames, iface, (String)name, func));
            interfaces.add(iface);
        }
        if (this.functions.isEmpty()) {
            if (implementation != null) {
                throw new IllegalArgumentException('\'' + implementation.getClass().getName() + "' is not a Thrift service implementation.");
            }
            throw new IllegalArgumentException("not a Thrift service interface: " + candidateInterfaces);
        }
        return Collections.unmodifiableSet(interfaces);
    }

    @Nullable
    private static Map<String, ProcessFunction<?, ?>> getThriftProcessMap(@Nullable Object service, Class<?> iface) {
        String name = iface.getName();
        if (!name.endsWith("$Iface")) {
            return null;
        }
        String processorName = name.substring(0, name.length() - 5) + "Processor";
        try {
            Class<?> processorClass = Class.forName(processorName, false, iface.getClassLoader());
            if (!TBaseProcessor.class.isAssignableFrom(processorClass)) {
                return null;
            }
            Constructor<?> processorConstructor = processorClass.getConstructor(iface);
            TBaseProcessor processor = (TBaseProcessor)processorConstructor.newInstance(service);
            Map processMap = processor.getProcessMapView();
            return processMap;
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve the process map from: {}", iface, (Object)e);
            return null;
        }
    }

    @Nullable
    private static Map<String, AsyncProcessFunction<?, ?, ?>> getThriftAsyncProcessMap(@Nullable Object service, Class<?> iface) {
        String name = iface.getName();
        if (!name.endsWith("$AsyncIface")) {
            return null;
        }
        String processorName = name.substring(0, name.length() - 10) + "AsyncProcessor";
        try {
            Class<?> processorClass = Class.forName(processorName, false, iface.getClassLoader());
            if (!TBaseAsyncProcessor.class.isAssignableFrom(processorClass)) {
                return null;
            }
            Constructor<?> processorConstructor = processorClass.getConstructor(iface);
            TBaseAsyncProcessor processor = (TBaseAsyncProcessor)processorConstructor.newInstance(service);
            Map processMap = processor.getProcessMapView();
            return processMap;
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve the asynchronous process map from:: {}", iface, (Object)e);
            return null;
        }
    }

    private void registerFunction(Set<String> methodNames, Class<?> iface, String name, Object func) {
        if (methodNames.contains(name)) {
            logger.warn("duplicate Thrift method name: " + name);
            return;
        }
        methodNames.add(name);
        try {
            ThriftFunction f = func instanceof ProcessFunction ? new ThriftFunction(iface, (ProcessFunction)func) : new ThriftFunction(iface, (AsyncProcessFunction)func);
            this.functions.put(name, f);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to retrieve function metadata: " + iface.getName() + '.' + name + "()", e);
        }
    }

    public Set<Class<?>> interfaces() {
        return this.interfaces;
    }

    @Nullable
    public ThriftFunction function(String method) {
        return this.functions.get(method);
    }
}

