/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.docs.DocStringExtractor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class ThriftDocStringExtractor
extends DocStringExtractor {
    private static final TypeReference<HashMap<String, Object>> JSON_VALUE_TYPE = new TypeReference<HashMap<String, Object>>(){};
    private static final String FQCN_DELIM = ".";
    private static final String DELIM = "/";

    ThriftDocStringExtractor() {
        super("META-INF/armeria/thrift", "com.linecorp.armeria.thrift.jsonDir");
    }

    protected boolean acceptFile(String filename) {
        return filename.endsWith(".json");
    }

    protected Map<String, String> getDocStringsFromFiles(Map<String, byte[]> files) {
        ImmutableMap.Builder docStrings = ImmutableMap.builder();
        for (byte[] file : files.values()) {
            try {
                Map json = (Map)new ObjectMapper().readValue(file, JSON_VALUE_TYPE);
                Map namespaces = (Map)json.getOrDefault("namespaces", ImmutableMap.of());
                String packageName = (String)namespaces.get("java");
                json.forEach((key, children) -> {
                    if (children instanceof Collection) {
                        Collection castChildren = (Collection)children;
                        castChildren.forEach(grandChild -> ThriftDocStringExtractor.traverseChildren((ImmutableMap.Builder<String, String>)docStrings, packageName, FQCN_DELIM, grandChild));
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return docStrings.build();
    }

    private static void traverseChildren(ImmutableMap.Builder<String, String> docStrings, String prefix, String delimiter, Object node) {
        if (node instanceof Map) {
            String childPrefix;
            Map map = (Map)node;
            String name = (String)map.get("name");
            String doc = (String)map.get("doc");
            if (name != null) {
                childPrefix = (String)MoreObjects.firstNonNull((Object)prefix, (Object)"") + delimiter + name;
                if (doc != null) {
                    docStrings.put((Object)childPrefix, (Object)doc.trim());
                }
            } else {
                childPrefix = prefix;
            }
            map.forEach((key, value) -> ThriftDocStringExtractor.traverseChildren(docStrings, childPrefix, DELIM, value));
        } else if (node instanceof Iterable) {
            Iterable children = (Iterable)node;
            children.forEach(child -> ThriftDocStringExtractor.traverseChildren(docStrings, prefix, DELIM, child));
        }
    }
}

