/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import java.util.Objects;
import org.apache.thrift.protocol.TMessage;

public abstract class ThriftMessage {
    private final TMessage header;

    ThriftMessage(TMessage header) {
        this.header = Objects.requireNonNull(header, "header");
    }

    public final TMessage header() {
        return this.header;
    }

    public int hashCode() {
        return this.header.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThriftMessage)) {
            return false;
        }
        return this.header.equals((Object)((ThriftMessage)o).header);
    }

    final String typeStr() {
        return ThriftMessage.typeStr(this.header.type);
    }

    static String typeStr(byte type) {
        switch (type) {
            case 1: {
                return "CALL";
            }
            case 4: {
                return "ONEWAY";
            }
            case 2: {
                return "REPLY";
            }
            case 3: {
                return "EXCEPTION";
            }
        }
        return "UNKNOWN(" + (type & 0xFF) + ')';
    }
}

