/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.thrift;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DecoratingClientFactory;
import com.linecorp.armeria.client.DefaultClientBuilderParams;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.thrift.DefaultTHttpClient;
import com.linecorp.armeria.client.thrift.THttpClient;
import com.linecorp.armeria.client.thrift.THttpClientDelegate;
import com.linecorp.armeria.client.thrift.THttpClientInvocationHandler;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.annotation.Nullable;

final class THttpClientFactory
extends DecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES;

    THttpClientFactory(ClientFactory httpClientFactory) {
        super(httpClientFactory);
    }

    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public <T> T newClient(URI uri, Class<T> clientType, ClientOptions options) {
        Scheme scheme = this.validateScheme(uri);
        Endpoint endpoint = THttpClientFactory.newEndpoint((URI)uri);
        return this.newClient(uri, scheme, endpoint, clientType, options);
    }

    public <T> T newClient(Scheme scheme, Endpoint endpoint, @Nullable String path, Class<T> clientType, ClientOptions options) {
        URI uri = endpoint.toUri(scheme, path);
        return this.newClient(uri, scheme, endpoint, clientType, options);
    }

    private <T> T newClient(URI uri, Scheme scheme, Endpoint endpoint, Class<T> clientType, ClientOptions options) {
        SerializationFormat serializationFormat = scheme.serializationFormat();
        RpcClient delegate = options.decoration().rpcDecorate((RpcClient)new THttpClientDelegate(this.newHttpClient(uri, scheme, options), serializationFormat));
        if (clientType == THttpClient.class) {
            DefaultTHttpClient client = new DefaultTHttpClient((ClientBuilderParams)new DefaultClientBuilderParams((ClientFactory)this, uri, THttpClient.class, options), delegate, this.meterRegistry(), scheme.sessionProtocol(), endpoint);
            return (T)client;
        }
        DefaultTHttpClient thriftClient = new DefaultTHttpClient((ClientBuilderParams)new DefaultClientBuilderParams((ClientFactory)this, THttpClientFactory.pathlessUri(uri), THttpClient.class, options), delegate, this.meterRegistry(), scheme.sessionProtocol(), endpoint);
        Object client = Proxy.newProxyInstance(clientType.getClassLoader(), new Class[]{clientType}, (InvocationHandler)new THttpClientInvocationHandler((ClientBuilderParams)new DefaultClientBuilderParams((ClientFactory)this, uri, clientType, options), thriftClient, (String)MoreObjects.firstNonNull((Object)uri.getRawPath(), (Object)"/"), uri.getFragment()));
        return (T)client;
    }

    private HttpClient newHttpClient(URI uri, Scheme scheme, ClientOptions options) {
        try {
            HttpClient client = (HttpClient)this.delegate().newClient(new URI(Scheme.of((SerializationFormat)SerializationFormat.NONE, (SessionProtocol)scheme.sessionProtocol()).uriText(), uri.getRawAuthority(), null, null, null), HttpClient.class, options);
            return client;
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    private static URI pathlessUri(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getRawAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SessionProtocol p : SessionProtocol.values()) {
            for (SerializationFormat f : ThriftSerializationFormats.values()) {
                builder.add((Object)Scheme.of((SerializationFormat)f, (SessionProtocol)p));
            }
        }
        SUPPORTED_SCHEMES = builder.build();
    }
}

