/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.thrift;

import com.linecorp.armeria.internal.Types;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.thrift.ThriftFunction;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.thrift.AsyncProcessFunction;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.TBaseProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftServiceMetadata {
    private static final Logger logger = LoggerFactory.getLogger(ThriftServiceMetadata.class);
    private final Set<Class<?>> interfaces;
    private final Map<String, ThriftFunction> functions = new HashMap<String, ThriftFunction>();

    public ThriftServiceMetadata(Object implementation) {
        this((Iterable<?>)ImmutableList.of((Object)Objects.requireNonNull(implementation, "implementation")));
    }

    public ThriftServiceMetadata(Iterable<?> implementations) {
        Objects.requireNonNull(implementations, "implementations");
        ImmutableSet.Builder interfaceBuilder = ImmutableSet.builder();
        implementations.forEach(implementation -> {
            Objects.requireNonNull(implementation, "implementations contains null.");
            interfaceBuilder.addAll(this.init(implementation));
        });
        this.interfaces = interfaceBuilder.build();
    }

    public ThriftServiceMetadata(Class<?> serviceType) {
        Objects.requireNonNull(serviceType, "serviceType");
        this.interfaces = this.init(null, Collections.singleton(serviceType));
    }

    private Set<Class<?>> init(Object implementation) {
        return this.init(implementation, Types.getAllInterfaces(implementation.getClass()));
    }

    private Set<Class<?>> init(@Nullable Object implementation, Iterable<Class<?>> candidateInterfaces) {
        HashSet interfaces = new HashSet();
        for (Class<?> iface : candidateInterfaces) {
            Map<String, ProcessFunction<?, ?>> processMap;
            Map<String, AsyncProcessFunction<?, ?, ?>> asyncProcessMap = ThriftServiceMetadata.getThriftAsyncProcessMap(implementation, iface);
            if (asyncProcessMap != null) {
                asyncProcessMap.forEach((name, func) -> this.registerFunction(iface, (String)name, func, implementation));
                interfaces.add(iface);
            }
            if ((processMap = ThriftServiceMetadata.getThriftProcessMap(implementation, iface)) == null) continue;
            processMap.forEach((name, func) -> this.registerFunction(iface, (String)name, func, implementation));
            interfaces.add(iface);
        }
        if (this.functions.isEmpty()) {
            if (implementation != null) {
                throw new IllegalArgumentException('\'' + implementation.getClass().getName() + "' is not a Thrift service implementation.");
            }
            throw new IllegalArgumentException("not a Thrift service interface: " + candidateInterfaces);
        }
        return Collections.unmodifiableSet(interfaces);
    }

    @Nullable
    private static Map<String, ProcessFunction<?, ?>> getThriftProcessMap(@Nullable Object service, Class<?> iface) {
        String name = iface.getName();
        if (!name.endsWith("$Iface")) {
            return null;
        }
        String processorName = name.substring(0, name.length() - 5) + "Processor";
        try {
            Class<?> processorClass = Class.forName(processorName, false, iface.getClassLoader());
            if (!TBaseProcessor.class.isAssignableFrom(processorClass)) {
                return null;
            }
            Constructor<?> processorConstructor = processorClass.getConstructor(iface);
            TBaseProcessor processor = (TBaseProcessor)processorConstructor.newInstance(service);
            Map processMap = processor.getProcessMapView();
            return processMap;
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve the process map from: {}", iface, (Object)e);
            return null;
        }
    }

    @Nullable
    private static Map<String, AsyncProcessFunction<?, ?, ?>> getThriftAsyncProcessMap(@Nullable Object service, Class<?> iface) {
        String name = iface.getName();
        if (!name.endsWith("$AsyncIface")) {
            return null;
        }
        String processorName = name.substring(0, name.length() - 10) + "AsyncProcessor";
        try {
            Class<?> processorClass = Class.forName(processorName, false, iface.getClassLoader());
            if (!TBaseAsyncProcessor.class.isAssignableFrom(processorClass)) {
                return null;
            }
            Constructor<?> processorConstructor = processorClass.getConstructor(iface);
            TBaseAsyncProcessor processor = (TBaseAsyncProcessor)processorConstructor.newInstance(service);
            Map processMap = processor.getProcessMapView();
            return processMap;
        }
        catch (Exception e) {
            logger.debug("Failed to retrieve the asynchronous process map from:: {}", iface, (Object)e);
            return null;
        }
    }

    private void registerFunction(Class<?> iface, String name, Object func, @Nullable Object implementation) {
        if (this.functions.containsKey(name)) {
            logger.warn("duplicate Thrift method name: " + name);
            return;
        }
        try {
            ThriftFunction f = func instanceof ProcessFunction ? new ThriftFunction(iface, (ProcessFunction)func, implementation) : new ThriftFunction(iface, (AsyncProcessFunction)func, implementation);
            this.functions.put(name, f);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to retrieve function metadata: " + iface.getName() + '.' + name + "()", e);
        }
    }

    public Set<Class<?>> interfaces() {
        return this.interfaces;
    }

    @Nullable
    public ThriftFunction function(String method) {
        return this.functions.get(method);
    }
}

