/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.linecorp.armeria.common.thrift.ThriftCall;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactories;
import com.linecorp.armeria.common.thrift.ThriftReply;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TTransport;

final class ThriftJacksonSerializers
extends Serializers.Base
implements Serializable {
    private static final long serialVersionUID = -285900387635271875L;

    ThriftJacksonSerializers() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class rawType = type.getRawClass();
        if (TMessage.class.isAssignableFrom(rawType)) {
            return new TMessageJsonSerializer();
        }
        if (TBase.class.isAssignableFrom(rawType)) {
            return new TBaseJsonSerializer();
        }
        if (TApplicationException.class.isAssignableFrom(rawType)) {
            return new TApplicationExceptionJsonSerializer();
        }
        if (ThriftCall.class.isAssignableFrom(rawType)) {
            return new ThriftCallJsonSerializer();
        }
        if (ThriftReply.class.isAssignableFrom(rawType)) {
            return new ThriftReplyJsonSerializer();
        }
        return super.findSerializer(config, type, beanDesc);
    }

    static void serializeTMessage(TMessage value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", value.name);
        gen.writeNumberField("type", (int)value.type);
        gen.writeNumberField("seqid", value.seqid);
        gen.writeEndObject();
    }

    static void serializeTBase(@Nullable TBase value, JsonGenerator gen) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        gen.writeRawValue(ThriftJacksonSerializers.serializeTBaseLike(protocol -> {
            try {
                value.write(protocol);
            }
            catch (TException ex) {
                throw new IllegalArgumentException(ex);
            }
        }));
    }

    static void serializeTApplicationException(@Nullable TApplicationException value, JsonGenerator gen) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        gen.writeRawValue(ThriftJacksonSerializers.serializeTBaseLike(protocol -> {
            try {
                value.write(protocol);
            }
            catch (TException ex) {
                throw new IllegalArgumentException(ex);
            }
        }));
    }

    private static String serializeTBaseLike(Consumer<TProtocol> writer) {
        TMemoryBuffer buffer = new TMemoryBuffer(1024);
        TProtocol protocol = ThriftProtocolFactories.TEXT.getProtocol((TTransport)buffer);
        writer.accept(protocol);
        return new String(buffer.getArray(), 0, buffer.length());
    }

    static final class TMessageJsonSerializer
    extends StdSerializer<TMessage> {
        private static final long serialVersionUID = 9105150745657053783L;

        TMessageJsonSerializer() {
            super(TMessage.class);
        }

        public void serialize(TMessage value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ThriftJacksonSerializers.serializeTMessage(value, gen);
        }
    }

    private static final class TBaseJsonSerializer
    extends StdSerializer<TBase> {
        private static final long serialVersionUID = -7954242119098597530L;

        TBaseJsonSerializer() {
            super(TBase.class);
        }

        public void serialize(TBase value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ThriftJacksonSerializers.serializeTBase(value, gen);
        }
    }

    private static final class TApplicationExceptionJsonSerializer
    extends StdSerializer<TApplicationException> {
        private static final long serialVersionUID = -7552338111791933510L;

        TApplicationExceptionJsonSerializer() {
            super(TApplicationException.class);
        }

        public void serialize(TApplicationException value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ThriftJacksonSerializers.serializeTApplicationException(value, gen);
        }
    }

    static final class ThriftCallJsonSerializer
    extends StdSerializer<ThriftCall> {
        private static final long serialVersionUID = -4873295256482417316L;

        ThriftCallJsonSerializer() {
            super(ThriftCall.class);
        }

        public void serialize(ThriftCall value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("header");
            ThriftJacksonSerializers.serializeTMessage(value.header(), gen);
            gen.writeFieldName("args");
            ThriftJacksonSerializers.serializeTBase(value.args(), gen);
            gen.writeEndObject();
        }
    }

    static final class ThriftReplyJsonSerializer
    extends StdSerializer<ThriftReply> {
        private static final long serialVersionUID = -783551224966265113L;

        ThriftReplyJsonSerializer() {
            super(ThriftReply.class);
        }

        public void serialize(ThriftReply value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            TApplicationException exception;
            TBase<?, ?> result;
            if (value == null) {
                gen.writeNull();
                return;
            }
            gen.writeStartObject();
            gen.writeFieldName("header");
            ThriftJacksonSerializers.serializeTMessage(value.header(), gen);
            if (value.isException()) {
                result = null;
                exception = value.exception();
            } else {
                result = value.result();
                exception = null;
            }
            gen.writeFieldName("result");
            ThriftJacksonSerializers.serializeTBase(result, gen);
            gen.writeFieldName("exception");
            ThriftJacksonSerializers.serializeTApplicationException(exception, gen);
            gen.writeEndObject();
        }
    }
}

