/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.thrift;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class TByteBufTransport
extends TTransport {
    private final ByteBuf buf;

    public TByteBufTransport(ByteBuf buf) {
        this.buf = Objects.requireNonNull(buf, "buf");
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public void open() {
    }

    public int read(byte[] buf, int off, int len) {
        int amtToRead;
        int bytesRemaining = this.buf.readableBytes();
        int n = amtToRead = len > bytesRemaining ? bytesRemaining : len;
        if (amtToRead > 0) {
            this.buf.readBytes(buf, off, amtToRead);
        }
        return amtToRead;
    }

    public int readAll(byte[] buf, int off, int len) throws TTransportException {
        int bytesRemaining = this.buf.readableBytes();
        if (len > bytesRemaining) {
            throw new TTransportException("unexpected end of frame");
        }
        this.buf.readBytes(buf, off, len);
        return len;
    }

    public void write(byte[] buf, int off, int len) {
        this.buf.writeBytes(buf, off, len);
    }

    @Nullable
    public byte[] getBuffer() {
        ByteBuf buf = this.buf;
        if (!buf.hasArray()) {
            return null;
        }
        return buf.array();
    }

    public int getBufferPosition() {
        ByteBuf buf = this.buf;
        if (!buf.hasArray()) {
            return 0;
        }
        return buf.arrayOffset() + buf.readerIndex();
    }

    public int getBytesRemainingInBuffer() {
        ByteBuf buf = this.buf;
        if (buf.hasArray()) {
            return buf.readableBytes();
        }
        return -1;
    }

    public void consumeBuffer(int len) {
        this.buf.skipBytes(len);
    }
}

