/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.common.thrift.text.TTextProtocolFactory;
import java.util.Objects;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public final class ThriftProtocolFactories {
    public static final TProtocolFactory BINARY = new TBinaryProtocol.Factory(){
        private static final long serialVersionUID = -9020693963961565748L;

        public String toString() {
            return "TProtocolFactory(binary)";
        }
    };
    public static final TProtocolFactory COMPACT = new TCompactProtocol.Factory(){
        private static final long serialVersionUID = 1629726795326210377L;

        public String toString() {
            return "TProtocolFactory(compact)";
        }
    };
    public static final TProtocolFactory JSON = new TJSONProtocol.Factory(){
        private static final long serialVersionUID = 7690636602996870153L;

        public String toString() {
            return "TProtocolFactory(JSON)";
        }
    };
    public static final TProtocolFactory TEXT = TTextProtocolFactory.get();

    public static TProtocolFactory get(SerializationFormat serializationFormat) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        if (serializationFormat == ThriftSerializationFormats.BINARY) {
            return BINARY;
        }
        if (serializationFormat == ThriftSerializationFormats.COMPACT) {
            return COMPACT;
        }
        if (serializationFormat == ThriftSerializationFormats.JSON) {
            return JSON;
        }
        if (serializationFormat == ThriftSerializationFormats.TEXT) {
            return TEXT;
        }
        throw new IllegalArgumentException("non-Thrift serializationFormat: " + serializationFormat);
    }

    public static SerializationFormat toSerializationFormat(TProtocolFactory protoFactory) {
        Objects.requireNonNull(protoFactory, "protoFactory");
        if (protoFactory instanceof TBinaryProtocol.Factory) {
            return ThriftSerializationFormats.BINARY;
        }
        if (protoFactory instanceof TCompactProtocol.Factory) {
            return ThriftSerializationFormats.COMPACT;
        }
        if (protoFactory instanceof TJSONProtocol.Factory) {
            return ThriftSerializationFormats.JSON;
        }
        if (protoFactory instanceof TTextProtocolFactory) {
            return ThriftSerializationFormats.TEXT;
        }
        throw new IllegalArgumentException("unsupported TProtocolFactory: " + protoFactory.getClass().getName());
    }

    private ThriftProtocolFactories() {
    }
}

