/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

public final class ThriftFuture<T>
extends EventLoopCheckingFuture<T>
implements AsyncMethodCallback<T> {
    public static <T> ThriftFuture<T> completedFuture(@Nullable T value) {
        ThriftFuture<T> future = new ThriftFuture<T>();
        future.onComplete(value);
        return future;
    }

    public static <T> ThriftFuture<T> exceptionallyCompletedFuture(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        ThriftFuture<T> future = new ThriftFuture<T>();
        future.onError(cause instanceof Exception ? (Exception)cause : new CompletionException(cause));
        return future;
    }

    public void onComplete(@Nullable T value) {
        this.complete(value);
    }

    public void onError(Exception cause) {
        this.completeExceptionally(cause);
    }
}

