/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public final class ThriftSerializationFormats {
    public static final SerializationFormat BINARY = SerializationFormat.of((String)"tbinary");
    public static final SerializationFormat COMPACT = SerializationFormat.of((String)"tcompact");
    public static final SerializationFormat JSON = SerializationFormat.of((String)"tjson");
    public static final SerializationFormat TEXT = SerializationFormat.of((String)"ttext");
    public static final SerializationFormat TEXT_NAMED_ENUM = SerializationFormat.of((String)"ttext-named-enum");
    private static final Set<SerializationFormat> THRIFT_FORMATS = ImmutableSet.of((Object)BINARY, (Object)COMPACT, (Object)JSON, (Object)TEXT, (Object)TEXT_NAMED_ENUM);

    public static Set<SerializationFormat> values() {
        return THRIFT_FORMATS;
    }

    public static boolean isThrift(SerializationFormat format) {
        return ThriftSerializationFormats.values().contains(Objects.requireNonNull(format, "format"));
    }

    private ThriftSerializationFormats() {
    }
}

