/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactoryProvider;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.thrift.protocol.TProtocolFactory;

public final class ThriftSerializationFormats {
    public static final SerializationFormat BINARY = SerializationFormat.of((String)"tbinary");
    public static final SerializationFormat COMPACT = SerializationFormat.of((String)"tcompact");
    public static final SerializationFormat JSON = SerializationFormat.of((String)"tjson");
    public static final SerializationFormat TEXT = SerializationFormat.of((String)"ttext");
    public static final SerializationFormat TEXT_NAMED_ENUM = SerializationFormat.of((String)"ttext-named-enum");
    private static final Map<SerializationFormat, TProtocolFactory> knownProtocolFactories;

    public static TProtocolFactory protocolFactory(SerializationFormat serializationFormat) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        TProtocolFactory value = knownProtocolFactories.get(serializationFormat);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Unsupported Thrift serializationFormat: %s", (Object)serializationFormat);
        return value;
    }

    public static Set<SerializationFormat> values() {
        return knownProtocolFactories.keySet();
    }

    public static boolean isThrift(SerializationFormat format) {
        return ThriftSerializationFormats.values().contains(Objects.requireNonNull(format, "format"));
    }

    private ThriftSerializationFormats() {
    }

    static {
        ImmutableList providers = ImmutableList.copyOf(ServiceLoader.load(ThriftProtocolFactoryProvider.class, ThriftProtocolFactoryProvider.class.getClassLoader()));
        knownProtocolFactories = (Map)providers.stream().map(ThriftProtocolFactoryProvider::entries).flatMap(Collection::stream).collect(ImmutableMap.toImmutableMap(e -> e.serializationFormat, e -> e.tProtocolFactory));
    }
}

