/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.thrift;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.UserClient;
import com.linecorp.armeria.client.thrift.THttpClient;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.thrift.THttpClientDelegate;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.PathAndQuery;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import org.apache.thrift.transport.TTransportException;

final class DefaultTHttpClient
extends UserClient<RpcRequest, RpcResponse>
implements THttpClient {
    private static final RequestOptions UNARY_REQUEST_OPTIONS = RequestOptions.builder().exchangeType(ExchangeType.UNARY).build();

    DefaultTHttpClient(ClientBuilderParams params, RpcClient delegate, MeterRegistry meterRegistry) {
        super(params, (Client)delegate, meterRegistry, RpcResponse::from, (ctx, cause) -> RpcResponse.ofFailure((Throwable)THttpClientDelegate.decodeException(cause, null)));
    }

    @Override
    public RpcResponse execute(String path, Class<?> serviceType, String method, Object ... args) {
        return this.execute0(path, serviceType, null, method, args);
    }

    @Override
    public RpcResponse executeMultiplexed(String path, Class<?> serviceType, String serviceName, String method, Object ... args) {
        Objects.requireNonNull(serviceName, "serviceName");
        return this.execute0(path, serviceType, serviceName, method, args);
    }

    private RpcResponse execute0(String path, Class<?> serviceType, @Nullable String serviceName, String method, Object[] args) {
        path = ArmeriaHttpUtil.concatPaths((String)this.uri().getRawPath(), (String)path);
        PathAndQuery pathAndQuery = PathAndQuery.parse((String)path);
        if (pathAndQuery == null) {
            return RpcResponse.ofFailure((Throwable)new TTransportException((Throwable)new IllegalArgumentException("invalid path: " + path)));
        }
        pathAndQuery.storeInCache(path);
        RpcRequest call = RpcRequest.of(serviceType, (String)method, (Object[])args);
        return (RpcResponse)this.execute(this.scheme().sessionProtocol(), HttpMethod.POST, pathAndQuery.path(), null, serviceName, (Request)call, UNARY_REQUEST_OPTIONS);
    }

    @Override
    public RpcClient unwrap() {
        return (RpcClient)super.unwrap();
    }
}

