/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactoryProvider;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.thrift.protocol.TProtocolFactory;

public final class ThriftSerializationFormats {
    public static final SerializationFormat BINARY = SerializationFormat.of((String)"tbinary");
    public static final SerializationFormat COMPACT = SerializationFormat.of((String)"tcompact");
    public static final SerializationFormat JSON = SerializationFormat.of((String)"tjson");
    public static final SerializationFormat TEXT = SerializationFormat.of((String)"ttext");
    public static final SerializationFormat TEXT_NAMED_ENUM = SerializationFormat.of((String)"ttext-named-enum");
    private static final List<ThriftProtocolFactoryProvider> protocolFactoryProviders = ImmutableList.copyOf(ServiceLoader.load(ThriftProtocolFactoryProvider.class, ThriftProtocolFactoryProvider.class.getClassLoader()));
    private static final Map<SerializationFormat, TProtocolFactory> lengthUnlimitedProtocolFactories = (Map)protocolFactoryProviders.stream().flatMap(provider -> provider.serializationFormats().stream().map(format -> {
        TProtocolFactory factory = provider.protocolFactory((SerializationFormat)format, 0, 0);
        return factory != null ? Maps.immutableEntry((Object)format, (Object)factory) : null;
    })).filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Set<SerializationFormat> knownSerializationFormats = lengthUnlimitedProtocolFactories.keySet();

    @Deprecated
    public static TProtocolFactory protocolFactory(SerializationFormat serializationFormat) {
        return ThriftSerializationFormats.protocolFactory(serializationFormat, 0, 0);
    }

    public static TProtocolFactory protocolFactory(SerializationFormat serializationFormat, int maxStringLength, int maxContainerLength) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        if (maxStringLength == 0 && maxContainerLength == 0) {
            TProtocolFactory protocolFactory = lengthUnlimitedProtocolFactories.get(serializationFormat);
            if (protocolFactory != null) {
                return protocolFactory;
            }
            throw ThriftSerializationFormats.newUnsupportedFormatException(serializationFormat);
        }
        for (ThriftProtocolFactoryProvider provider : protocolFactoryProviders) {
            TProtocolFactory protocolFactory = provider.protocolFactory(serializationFormat, maxStringLength, maxContainerLength);
            if (protocolFactory == null) continue;
            return protocolFactory;
        }
        throw ThriftSerializationFormats.newUnsupportedFormatException(serializationFormat);
    }

    private static IllegalArgumentException newUnsupportedFormatException(SerializationFormat serializationFormat) {
        return new IllegalArgumentException("Unsupported Thrift serializationFormat: " + serializationFormat);
    }

    public static Set<SerializationFormat> values() {
        return knownSerializationFormats;
    }

    public static boolean isThrift(SerializationFormat format) {
        return ThriftSerializationFormats.values().contains(Objects.requireNonNull(format, "format"));
    }

    private ThriftSerializationFormats() {
    }
}

