/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.common.thrift.text.TTextProtocolFactory;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public final class ThriftProtocolFactories {
    @Deprecated
    public static final TProtocolFactory BINARY = ThriftProtocolFactories.binary(0, 0);
    @Deprecated
    public static final TProtocolFactory COMPACT = ThriftProtocolFactories.compact(0, 0);
    @Deprecated
    public static final TProtocolFactory JSON = new TJSONProtocol.Factory(){
        private static final long serialVersionUID = 7690636602996870153L;

        public String toString() {
            return "TProtocolFactory(JSON)";
        }
    };
    @Deprecated
    public static final TProtocolFactory TEXT = TTextProtocolFactory.get();
    @Deprecated
    public static final TProtocolFactory TEXT_NAMED_ENUM = TTextProtocolFactory.get(true);

    @Deprecated
    public static TProtocolFactory get(SerializationFormat serializationFormat) {
        return ThriftSerializationFormats.protocolFactory(serializationFormat);
    }

    public static TProtocolFactory binary(int maxStringLength, int maxContainerLength) {
        Preconditions.checkArgument((maxStringLength >= 0 ? 1 : 0) != 0, (String)"maxStringLength: %s (expected: >= 0)", (int)maxStringLength);
        Preconditions.checkArgument((maxContainerLength >= 0 ? 1 : 0) != 0, (String)"maxContainerLength: %s (expected: >= 0)", (int)maxContainerLength);
        final int maxStringLength0 = maxStringLength == 0 ? -1 : maxStringLength;
        final int maxContainerLength0 = maxContainerLength == 0 ? -1 : maxContainerLength;
        return new TBinaryProtocol.Factory(false, true, maxStringLength0, maxContainerLength0){
            private static final long serialVersionUID = -9020693963961565748L;

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).addValue((Object)"BINARY").add("maxStringLength", maxStringLength0).add("maxContainerLength", maxContainerLength0).toString();
            }
        };
    }

    public static TProtocolFactory compact(int maxStringLength, int maxContainerLength) {
        Preconditions.checkArgument((maxStringLength >= 0 ? 1 : 0) != 0, (String)"maxStringLength: %s (expected: >= 0)", (int)maxStringLength);
        Preconditions.checkArgument((maxContainerLength >= 0 ? 1 : 0) != 0, (String)"maxContainerLength: %s (expected: >= 0)", (int)maxContainerLength);
        final int maxStringLength0 = maxStringLength == 0 ? -1 : maxStringLength;
        final int maxContainerLength0 = maxContainerLength == 0 ? -1 : maxContainerLength;
        return new TCompactProtocol.Factory(maxStringLength0, maxContainerLength0){
            private static final long serialVersionUID = 1629726795326210377L;

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).addValue((Object)"COMPACT").add("maxStringLength", maxStringLength0).add("maxContainerLength", maxContainerLength0).toString();
            }
        };
    }

    public static TProtocolFactory json() {
        return JSON;
    }

    public static TProtocolFactory text() {
        return TEXT;
    }

    public static TProtocolFactory textNamedEnum() {
        return TEXT_NAMED_ENUM;
    }

    @Deprecated
    public static SerializationFormat toSerializationFormat(TProtocolFactory protoFactory) {
        Objects.requireNonNull(protoFactory, "protoFactory");
        if (protoFactory instanceof TBinaryProtocol.Factory) {
            return ThriftSerializationFormats.BINARY;
        }
        if (protoFactory instanceof TCompactProtocol.Factory) {
            return ThriftSerializationFormats.COMPACT;
        }
        if (protoFactory instanceof TJSONProtocol.Factory) {
            return ThriftSerializationFormats.JSON;
        }
        if (protoFactory instanceof TTextProtocolFactory) {
            TTextProtocolFactory factory = (TTextProtocolFactory)protoFactory;
            return factory.usesNamedEnums() ? ThriftSerializationFormats.TEXT_NAMED_ENUM : ThriftSerializationFormats.TEXT;
        }
        throw new IllegalArgumentException("unsupported TProtocolFactory: " + protoFactory.getClass().getName());
    }

    private ThriftProtocolFactories() {
    }
}

