/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.thrift;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactories;
import com.linecorp.armeria.internal.server.thrift.ThriftDocStringExtractor;
import com.linecorp.armeria.internal.server.thrift.ThriftNamedTypeInfoProvider;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.DocServiceFilter;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfoProvider;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.thrift.THttpService;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.meta_data.FieldMetaData;

public final class ThriftDocServicePlugin
implements DocServicePlugin {
    private static final String REQUEST_STRUCT_SUFFIX = "_args";
    @Nullable
    private static final MethodHandle legacyTSerializerToString;
    private final ThriftDocStringExtractor docstringExtractor = new ThriftDocStringExtractor();

    public String name() {
        return "thrift";
    }

    public Set<Class<? extends Service<?, ?>>> supportedServiceTypes() {
        return ImmutableSet.of(THttpService.class);
    }

    public ServiceSpecification generateSpecification(Set<ServiceConfig> serviceConfigs, DocServiceFilter filter, NamedTypeInfoProvider namedTypeInfoProvider) {
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(namedTypeInfoProvider, "namedTypeInfoProvider");
        LinkedHashMap map = new LinkedHashMap();
        for (ServiceConfig c : serviceConfigs) {
            THttpService service = (THttpService)((Object)c.service().as(THttpService.class));
            assert (service != null);
            service.entries().forEach((serviceName, entry) -> {
                for (Class<?> iface : entry.interfaces()) {
                    Class<?> serviceClass = iface.getEnclosingClass();
                    EntryBuilder builder = map.computeIfAbsent(serviceClass, cls -> new EntryBuilder(serviceClass));
                    Route route = c.route();
                    RoutePathType pathType = route.pathType();
                    if (pathType != RoutePathType.EXACT && pathType != RoutePathType.PREFIX) continue;
                    builder.endpoint(EndpointInfo.builder((String)c.virtualHost().hostnamePattern(), (String)((String)route.paths().get(0))).fragment(serviceName).defaultFormat(service.defaultSerializationFormat()).availableFormats(service.supportedSerializationFormats()).build());
                }
            });
        }
        List<Entry> entries = map.values().stream().map(EntryBuilder::build).collect(Collectors.toList());
        return this.generate(entries, filter, namedTypeInfoProvider);
    }

    @VisibleForTesting
    public ServiceSpecification generate(List<Entry> entries, DocServiceFilter filter, NamedTypeInfoProvider namedTypeInfoProvider) {
        List services = (List)entries.stream().map(e -> this.newServiceInfo(e.serviceType, e.endpointInfos, filter)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        return ServiceSpecification.generate((Iterable)services, typeSignature -> ThriftDocServicePlugin.newNamedTypeInfo(typeSignature, namedTypeInfoProvider));
    }

    @Nullable
    @VisibleForTesting
    ServiceInfo newServiceInfo(Class<?> serviceClass, Iterable<EndpointInfo> endpoints, DocServiceFilter filter) {
        Class<?> interfaceClass;
        Objects.requireNonNull(serviceClass, "serviceClass");
        String name = serviceClass.getName();
        ClassLoader serviceClassLoader = serviceClass.getClassLoader();
        String interfaceClassName = name + "$Iface";
        try {
            interfaceClass = Class.forName(interfaceClassName, false, serviceClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("failed to find a class: " + interfaceClassName, e);
        }
        Method[] methods = interfaceClass.getDeclaredMethods();
        List methodInfos = (List)Arrays.stream(methods).map(m -> this.newMethodInfo((Method)m, endpoints, filter)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (methodInfos.isEmpty()) {
            return null;
        }
        return new ServiceInfo(name, (Iterable)methodInfos);
    }

    @Nullable
    private MethodInfo newMethodInfo(Method method, Iterable<EndpointInfo> endpoints, DocServiceFilter filter) {
        Class<?> resultClass;
        Class<?> argsClass;
        String methodName = method.getName();
        Class<?> serviceClass = method.getDeclaringClass().getDeclaringClass();
        String serviceName = serviceClass.getName();
        if (!filter.test(this.name(), serviceName, methodName)) {
            return null;
        }
        ClassLoader classLoader = serviceClass.getClassLoader();
        String argsClassName = serviceName + '$' + methodName + REQUEST_STRUCT_SUFFIX;
        try {
            Class<?> argsClass0;
            argsClass = argsClass0 = Class.forName(argsClassName, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("failed to find a class: " + argsClassName, e);
        }
        try {
            resultClass = Class.forName(serviceName + '$' + methodName + "_result", false, classLoader);
        }
        catch (ClassNotFoundException ignored) {
            resultClass = null;
        }
        MethodInfo methodInfo = ThriftDocServicePlugin.newMethodInfo(methodName, argsClass, resultClass, method.getExceptionTypes(), endpoints);
        return methodInfo;
    }

    private static MethodInfo newMethodInfo(String name, Class<? extends TBase<?, ?>> argsClass, @Nullable Class<? extends TBase<?, ?>> resultClass, Class<? extends TException>[] exceptionClasses, Iterable<EndpointInfo> endpoints) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(argsClass, "argsClass");
        Objects.requireNonNull(exceptionClasses, "exceptionClasses");
        Objects.requireNonNull(endpoints, "endpoints");
        List parameters = (List)FieldMetaData.getStructMetaDataMap(argsClass).values().stream().map(fieldMetaData -> ThriftNamedTypeInfoProvider.newFieldInfo(argsClass, fieldMetaData)).collect(ImmutableList.toImmutableList());
        FieldInfo fieldInfo = null;
        if (resultClass != null) {
            Map resultMetaData = FieldMetaData.getStructMetaDataMap(resultClass);
            for (FieldMetaData fieldMetaData2 : resultMetaData.values()) {
                if (!"success".equals(fieldMetaData2.fieldName)) continue;
                fieldInfo = ThriftNamedTypeInfoProvider.newFieldInfo(resultClass, fieldMetaData2);
                break;
            }
        }
        TypeSignature returnTypeSignature = fieldInfo == null ? ThriftNamedTypeInfoProvider.VOID : fieldInfo.typeSignature();
        List exceptionTypeSignatures = (List)Arrays.stream(exceptionClasses).filter(e -> e != TException.class).map(TypeSignature::ofNamed).collect(ImmutableList.toImmutableList());
        return new MethodInfo(name, returnTypeSignature, (Iterable)parameters, (Iterable)exceptionTypeSignatures, endpoints, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), HttpMethod.POST, DescriptionInfo.empty());
    }

    private static NamedTypeInfo newNamedTypeInfo(TypeSignature typeSignature, NamedTypeInfoProvider namedTypeInfoProvider) {
        Class type = (Class)typeSignature.namedTypeDescriptor();
        if (type == null) {
            throw new IllegalArgumentException("cannot create a named type from: " + typeSignature);
        }
        assert (TBase.class.isAssignableFrom(type) || TEnum.class.isAssignableFrom(type) || TException.class.isAssignableFrom(type));
        NamedTypeInfo namedTypeInfo = namedTypeInfoProvider.newNamedTypeInfo((Object)type);
        return Objects.requireNonNull(namedTypeInfo, "namedTypeInfoProvider.newNamedTypeInfo() returned null");
    }

    public Map<String, DescriptionInfo> loadDocStrings(Set<ServiceConfig> serviceConfigs) {
        return (Map)serviceConfigs.stream().flatMap(c -> {
            THttpService service = (THttpService)((Object)((Object)c.service().as(THttpService.class)));
            assert (service != null);
            return service.entries().values().stream();
        }).flatMap(entry -> entry.interfaces().stream().map(Class::getClassLoader)).flatMap(loader -> this.docstringExtractor.getAllDocStrings((ClassLoader)loader).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> DescriptionInfo.of((String)((String)entry.getValue())), (a, b) -> a));
    }

    public Set<Class<?>> supportedExampleRequestTypes() {
        return ImmutableSet.of(TBase.class);
    }

    public String guessServiceName(Object exampleRequest) {
        TBase<?, ?> exampleTBase = ThriftDocServicePlugin.asTBase(exampleRequest);
        if (exampleTBase == null) {
            return null;
        }
        return exampleTBase.getClass().getEnclosingClass().getName();
    }

    public String guessServiceMethodName(Object exampleRequest) {
        TBase<?, ?> exampleTBase = ThriftDocServicePlugin.asTBase(exampleRequest);
        if (exampleTBase == null) {
            return null;
        }
        String typeName = exampleTBase.getClass().getName();
        return typeName.substring(typeName.lastIndexOf(36) + 1, typeName.length() - REQUEST_STRUCT_SUFFIX.length());
    }

    public String serializeExampleRequest(String serviceName, String methodName, Object exampleRequest) {
        if (!(exampleRequest instanceof TBase)) {
            return null;
        }
        TBase exampleTBase = (TBase)exampleRequest;
        try {
            TSerializer serializer = new TSerializer(ThriftProtocolFactories.text());
            if (legacyTSerializerToString != null) {
                try {
                    return legacyTSerializerToString.invoke(serializer, exampleTBase, StandardCharsets.UTF_8.name());
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Unexpected exception while serializing " + exampleTBase, ex);
                }
            }
            return serializer.toString(exampleTBase);
        }
        catch (TException e) {
            throw new Error("should never reach here", e);
        }
    }

    @Nullable
    private static TBase<?, ?> asTBase(Object exampleRequest) {
        TBase exampleTBase = (TBase)exampleRequest;
        Class<?> type = exampleTBase.getClass();
        if (!type.getName().endsWith(REQUEST_STRUCT_SUFFIX)) {
            return null;
        }
        Class<?> serviceType = type.getEnclosingClass();
        if (serviceType == null) {
            return null;
        }
        if (serviceType.getEnclosingClass() != null) {
            return null;
        }
        return exampleTBase;
    }

    public String toString() {
        return ThriftDocServicePlugin.class.getSimpleName();
    }

    static {
        MethodHandle methodHandle = null;
        try {
            methodHandle = MethodHandles.publicLookup().findVirtual(TSerializer.class, "toString", MethodType.methodType(String.class, TBase.class, String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        legacyTSerializerToString = methodHandle;
    }

    @VisibleForTesting
    public static final class Entry {
        final Class<?> serviceType;
        final List<EndpointInfo> endpointInfos;

        Entry(Class<?> serviceType, List<EndpointInfo> endpointInfos) {
            this.serviceType = serviceType;
            this.endpointInfos = ImmutableList.copyOf(endpointInfos);
        }
    }

    @VisibleForTesting
    public static final class EntryBuilder {
        private final Class<?> serviceType;
        private final List<EndpointInfo> endpointInfos = new ArrayList<EndpointInfo>();

        public EntryBuilder(Class<?> serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        }

        public EntryBuilder endpoint(EndpointInfo endpointInfo) {
            this.endpointInfos.add(Objects.requireNonNull(endpointInfo, "endpointInfo"));
            return this;
        }

        public Entry build() {
            return new Entry(this.serviceType, this.endpointInfos);
        }
    }
}

