/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.thrift;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfoProvider;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.ExceptionInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;

public final class ThriftDescriptiveTypeInfoProvider
implements DescriptiveTypeInfoProvider {
    static final TypeSignature VOID = TypeSignature.ofBase((String)"void");
    private static final TypeSignature BOOL = TypeSignature.ofBase((String)"bool");
    private static final TypeSignature I8 = TypeSignature.ofBase((String)"i8");
    private static final TypeSignature I16 = TypeSignature.ofBase((String)"i16");
    private static final TypeSignature I32 = TypeSignature.ofBase((String)"i32");
    private static final TypeSignature I64 = TypeSignature.ofBase((String)"i64");
    private static final TypeSignature DOUBLE = TypeSignature.ofBase((String)"double");
    private static final TypeSignature STRING = TypeSignature.ofBase((String)"string");
    private static final TypeSignature BINARY = TypeSignature.ofBase((String)"binary");

    @Nullable
    public DescriptiveTypeInfo newDescriptiveTypeInfo(Object typeDescriptor) {
        if (!(typeDescriptor instanceof Class)) {
            return null;
        }
        Class clazz = (Class)typeDescriptor;
        if (TEnum.class.isAssignableFrom(clazz)) {
            Class enumType = clazz;
            return ThriftDescriptiveTypeInfoProvider.newEnumInfo(enumType);
        }
        if (TException.class.isAssignableFrom(clazz)) {
            Class castType = clazz;
            return ThriftDescriptiveTypeInfoProvider.newExceptionInfo(castType);
        }
        if (TBase.class.isAssignableFrom(clazz)) {
            Class castType = clazz;
            return ThriftDescriptiveTypeInfoProvider.newStructInfo(castType);
        }
        return null;
    }

    @VisibleForTesting
    static EnumInfo newEnumInfo(Class<? extends Enum<? extends TEnum>> enumType) {
        List values = (List)Arrays.stream(enumType.getEnumConstants()).map(e -> new EnumValueInfo(e.name(), Integer.valueOf(((TEnum)e).getValue()))).collect(ImmutableList.toImmutableList());
        return new EnumInfo(enumType.getTypeName(), (Iterable)values);
    }

    @VisibleForTesting
    static ExceptionInfo newExceptionInfo(Class<? extends TException> exceptionClass) {
        List fields;
        Objects.requireNonNull(exceptionClass, "exceptionClass");
        String name = exceptionClass.getName();
        try {
            Map metaDataMap = (Map)exceptionClass.getDeclaredField("metaDataMap").get(null);
            fields = (List)metaDataMap.values().stream().map(fieldMetaData -> ThriftDescriptiveTypeInfoProvider.newFieldInfo(exceptionClass, fieldMetaData)).collect(ImmutableList.toImmutableList());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("will not happen", e);
        }
        catch (NoSuchFieldException ignored) {
            fields = Collections.emptyList();
        }
        return new ExceptionInfo(name, fields);
    }

    @VisibleForTesting
    static FieldInfo newFieldInfo(Class<?> parentType, FieldMetaData fieldMetaData) {
        Objects.requireNonNull(fieldMetaData, "fieldMetaData");
        FieldValueMetaData fieldValueMetaData = fieldMetaData.valueMetaData;
        Object typeSignature = fieldValueMetaData.isStruct() && fieldValueMetaData.isTypedef() && parentType.getSimpleName().equals(fieldValueMetaData.getTypedefName()) ? TypeSignature.ofStruct(parentType) : ThriftDescriptiveTypeInfoProvider.toTypeSignature(fieldValueMetaData);
        return FieldInfo.builder((String)fieldMetaData.fieldName, (TypeSignature)typeSignature).requirement(ThriftDescriptiveTypeInfoProvider.convertRequirement(fieldMetaData.requirementType)).build();
    }

    private static FieldRequirement convertRequirement(byte value) {
        switch (value) {
            case 1: {
                return FieldRequirement.REQUIRED;
            }
            case 2: {
                return FieldRequirement.OPTIONAL;
            }
            case 3: {
                return FieldRequirement.UNSPECIFIED;
            }
        }
        throw new IllegalArgumentException("unknown requirement type: " + value);
    }

    static TypeSignature toTypeSignature(FieldValueMetaData fieldValueMetaData) {
        if (fieldValueMetaData instanceof StructMetaData) {
            return TypeSignature.ofStruct((Class)((StructMetaData)fieldValueMetaData).structClass);
        }
        if (fieldValueMetaData instanceof EnumMetaData) {
            return TypeSignature.ofEnum((Class)((EnumMetaData)fieldValueMetaData).enumClass);
        }
        if (fieldValueMetaData instanceof ListMetaData) {
            return TypeSignature.ofList((TypeSignature)ThriftDescriptiveTypeInfoProvider.toTypeSignature(((ListMetaData)fieldValueMetaData).elemMetaData));
        }
        if (fieldValueMetaData instanceof SetMetaData) {
            return TypeSignature.ofSet((TypeSignature)ThriftDescriptiveTypeInfoProvider.toTypeSignature(((SetMetaData)fieldValueMetaData).elemMetaData));
        }
        if (fieldValueMetaData instanceof MapMetaData) {
            return TypeSignature.ofMap((TypeSignature)ThriftDescriptiveTypeInfoProvider.toTypeSignature(((MapMetaData)fieldValueMetaData).keyMetaData), (TypeSignature)ThriftDescriptiveTypeInfoProvider.toTypeSignature(((MapMetaData)fieldValueMetaData).valueMetaData));
        }
        if (fieldValueMetaData.isBinary()) {
            return BINARY;
        }
        switch (fieldValueMetaData.type) {
            case 1: {
                return VOID;
            }
            case 2: {
                return BOOL;
            }
            case 3: {
                return I8;
            }
            case 4: {
                return DOUBLE;
            }
            case 6: {
                return I16;
            }
            case 8: {
                return I32;
            }
            case 10: {
                return I64;
            }
            case 11: {
                return STRING;
            }
        }
        String unresolvedName = fieldValueMetaData.isTypedef() ? fieldValueMetaData.getTypedefName() : null;
        return TypeSignature.ofUnresolved((String)((String)MoreObjects.firstNonNull((Object)unresolvedName, (Object)"unknown")));
    }

    @VisibleForTesting
    static <T extends TBase<T, F>, F extends TFieldIdEnum> StructInfo newStructInfo(Class<?> structClass) {
        String name = structClass.getName();
        Map metaDataMap = FieldMetaData.getStructMetaDataMap(structClass);
        List fields = metaDataMap.values().stream().map(fieldMetaData -> ThriftDescriptiveTypeInfoProvider.newFieldInfo(structClass, fieldMetaData)).collect(Collectors.toList());
        return new StructInfo(name, fields);
    }
}

