/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimaps;
import com.linecorp.armeria.server.RpcService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.thrift.THttpService;
import com.linecorp.armeria.server.thrift.ThriftCallService;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class THttpServiceBuilder {
    private static final BiFunction<? super ServiceRequestContext, ? super Throwable, ? extends RpcResponse> defaultExceptionHandler = (ctx, cause) -> RpcResponse.ofFailure((Throwable)cause);
    private final ImmutableListMultimap.Builder<String, Object> implementationsBuilder = ImmutableListMultimap.builder();
    private SerializationFormat defaultSerializationFormat = ThriftSerializationFormats.BINARY;
    private Set<SerializationFormat> otherSerializationFormats = ThriftSerializationFormats.values();
    private boolean createOtherSerializations = true;
    @Nullable
    private Function<? super RpcService, ? extends RpcService> decoratorFunction;
    private BiFunction<? super ServiceRequestContext, ? super Throwable, ? extends RpcResponse> exceptionHandler = defaultExceptionHandler;
    private int maxRequestStringLength = -1;
    private int maxRequestContainerLength = -1;

    THttpServiceBuilder() {
    }

    public THttpServiceBuilder addService(String name, Object implementation) {
        this.implementationsBuilder.put((Object)name, implementation);
        return this;
    }

    public THttpServiceBuilder addService(Object implementation) {
        return this.addService("", implementation);
    }

    public THttpServiceBuilder otherSerializationFormats(SerializationFormat otherSerializationFormat) {
        Objects.requireNonNull(otherSerializationFormat, "otherSerializationFormat");
        return this.otherSerializationFormats((Iterable<SerializationFormat>)ImmutableList.of((Object)otherSerializationFormat));
    }

    public THttpServiceBuilder otherSerializationFormats(Iterable<SerializationFormat> otherSerializationFormats) {
        Objects.requireNonNull(otherSerializationFormats, "otherSerializationFormats");
        if (this.createOtherSerializations) {
            this.otherSerializationFormats = new LinkedHashSet<SerializationFormat>();
            this.createOtherSerializations = false;
        }
        otherSerializationFormats.forEach(this.otherSerializationFormats::add);
        return this;
    }

    public THttpServiceBuilder defaultSerializationFormat(SerializationFormat defaultSerializationFormat) {
        Objects.requireNonNull(defaultSerializationFormat, "defaultSerializationFormat");
        this.defaultSerializationFormat = defaultSerializationFormat;
        return this;
    }

    public THttpServiceBuilder maxRequestStringLength(int maxRequestStringLength) {
        Preconditions.checkArgument((maxRequestStringLength >= 0 ? 1 : 0) != 0, (String)"maxRequestStringLength: %s (expected: >= 0)", (int)maxRequestStringLength);
        this.maxRequestStringLength = maxRequestStringLength;
        return this;
    }

    public THttpServiceBuilder maxRequestContainerLength(int maxRequestContainerLength) {
        Preconditions.checkArgument((maxRequestContainerLength >= 0 ? 1 : 0) != 0, (String)"maxRequestContainerLength: %s (expected: >= 0)", (int)maxRequestContainerLength);
        this.maxRequestContainerLength = maxRequestContainerLength;
        return this;
    }

    public THttpServiceBuilder exceptionHandler(BiFunction<? super ServiceRequestContext, ? super Throwable, ? extends RpcResponse> exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
        return this;
    }

    public THttpServiceBuilder decorate(Function<? super RpcService, ? extends RpcService> decoratorFunction) {
        Objects.requireNonNull(decoratorFunction, "decoratorFunction");
        this.decoratorFunction = this.decoratorFunction == null ? decoratorFunction : this.decoratorFunction.andThen(decoratorFunction);
        return this;
    }

    private RpcService decorate(RpcService service) {
        if (this.decoratorFunction != null) {
            return (RpcService)service.decorate(this.decoratorFunction);
        }
        return service;
    }

    public THttpService build() {
        Map implementations = Multimaps.asMap((ListMultimap)this.implementationsBuilder.build());
        ThriftCallService tcs = ThriftCallService.of(implementations);
        return this.build0(tcs);
    }

    public Function<? super RpcService, THttpService> newDecorator() {
        return this::build0;
    }

    private THttpService build0(RpcService tcs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.defaultSerializationFormat);
        builder.addAll(this.otherSerializationFormats);
        return new THttpService(this.decorate(tcs), this.defaultSerializationFormat, (Set<SerializationFormat>)builder.build(), this.maxRequestStringLength, this.maxRequestContainerLength, this.exceptionHandler);
    }
}

