/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactories;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactoryProvider;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.apache.thrift.protocol.TProtocolFactory;

public final class DefaultThriftProtocolFactoryProvider
extends ThriftProtocolFactoryProvider {
    private static final Set<SerializationFormat> SERIALIZATION_FORMATS = ImmutableSet.of((Object)ThriftSerializationFormats.BINARY, (Object)ThriftSerializationFormats.COMPACT, (Object)ThriftSerializationFormats.JSON, (Object)ThriftSerializationFormats.TEXT, (Object)ThriftSerializationFormats.TEXT_NAMED_ENUM);

    @Override
    protected Set<SerializationFormat> serializationFormats() {
        return SERIALIZATION_FORMATS;
    }

    @Override
    protected TProtocolFactory protocolFactory(SerializationFormat serializationFormat, int maxStringLength, int maxContainerLength) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        if (!this.serializationFormats().contains(serializationFormat)) {
            return null;
        }
        if (serializationFormat == ThriftSerializationFormats.BINARY) {
            return ThriftProtocolFactories.binary(maxStringLength, maxContainerLength);
        }
        if (serializationFormat == ThriftSerializationFormats.COMPACT) {
            return ThriftProtocolFactories.compact(maxStringLength, maxContainerLength);
        }
        if (serializationFormat == ThriftSerializationFormats.JSON) {
            return ThriftProtocolFactories.json();
        }
        if (serializationFormat == ThriftSerializationFormats.TEXT) {
            return ThriftProtocolFactories.text();
        }
        if (serializationFormat == ThriftSerializationFormats.TEXT_NAMED_ENUM) {
            return ThriftProtocolFactories.textNamedEnum();
        }
        throw new Error();
    }
}

