/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.internal.common.thrift.TByteBufTransport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public final class ThriftProtocolUtil {
    private static final boolean SUPPORT_BINARY_MESSAGE_LENGTH_LIMIT;

    public static void maybeCheckMessageLength(SerializationFormat serializationFormat, ByteBuf buf, int maxStringLength) throws TProtocolException {
        if (ThriftProtocolUtil.supportsMessageLengthLimit(serializationFormat) || maxStringLength <= 0) {
            return;
        }
        if (buf.readableBytes() < 4) {
            return;
        }
        int length = buf.getInt(buf.readerIndex());
        if (length < 0) {
            return;
        }
        if (length > maxStringLength) {
            throw new TProtocolException(3, "Length exceeded max allowed: " + length);
        }
    }

    private static boolean supportsMessageLengthLimit(SerializationFormat serializationFormat) {
        if (serializationFormat != ThriftSerializationFormats.BINARY) {
            return true;
        }
        return SUPPORT_BINARY_MESSAGE_LENGTH_LIMIT;
    }

    private ThriftProtocolUtil() {
    }

    static {
        boolean supportMessageLengthLimit;
        block2: {
            supportMessageLengthLimit = false;
            TProtocolFactory binaryFactory = ThriftSerializationFormats.protocolFactory(ThriftSerializationFormats.BINARY, 5, 0);
            ByteBuf buf = Unpooled.buffer();
            buf.writeInt(6);
            buf.writeBytes("Hello".getBytes());
            TByteBufTransport transport = new TByteBufTransport(buf);
            TProtocol protocol = binaryFactory.getProtocol((TTransport)transport);
            try {
                protocol.readMessageBegin();
            }
            catch (TException e) {
                if (!(e instanceof TProtocolException) || ((TProtocolException)e).getType() != 3) break block2;
                supportMessageLengthLimit = true;
            }
        }
        SUPPORT_BINARY_MESSAGE_LENGTH_LIMIT = supportMessageLengthLimit;
    }
}

