/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.thrift;

import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.thrift.ThriftClientBuilder;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import java.net.URI;
import java.util.Objects;

@UnstableApi
public final class ThriftClients {
    public static <T> T newClient(String uri, Class<T> clientType) {
        return ThriftClients.builder(uri).build(clientType);
    }

    public static <T> T newClient(URI uri, Class<T> clientType) {
        return ThriftClients.builder(uri).build(clientType);
    }

    public static <T> T newClient(String scheme, EndpointGroup endpointGroup, Class<T> clientType) {
        return ThriftClients.builder(scheme, endpointGroup).build(clientType);
    }

    public static <T> T newClient(Scheme scheme, EndpointGroup endpointGroup, Class<T> clientType) {
        return ThriftClients.builder(scheme, endpointGroup).build(clientType);
    }

    public static <T> T newClient(String scheme, EndpointGroup endpointGroup, String path, Class<T> clientType) {
        return ThriftClients.builder(scheme, endpointGroup).path(path).build(clientType);
    }

    public static <T> T newClient(SessionProtocol protocol, EndpointGroup endpointGroup, Class<T> clientType) {
        return ThriftClients.builder(protocol, endpointGroup).build(clientType);
    }

    public static <T> T newClient(SessionProtocol protocol, EndpointGroup endpointGroup, String path, Class<T> clientType) {
        return ThriftClients.builder(protocol, endpointGroup).path(path).build(clientType);
    }

    public static ThriftClientBuilder builder(String uri) {
        return ThriftClients.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static ThriftClientBuilder builder(URI uri) {
        return new ThriftClientBuilder(Objects.requireNonNull(uri, "uri"));
    }

    public static ThriftClientBuilder builder(String scheme, EndpointGroup endpointGroup) {
        return ThriftClients.builder(Scheme.parse((String)Objects.requireNonNull(scheme, "scheme")), endpointGroup);
    }

    public static ThriftClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return ThriftClients.builder(Scheme.of((SerializationFormat)ThriftSerializationFormats.BINARY, (SessionProtocol)Objects.requireNonNull(protocol, "protocol")), endpointGroup);
    }

    public static ThriftClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new ThriftClientBuilder(scheme, endpointGroup);
    }

    private ThriftClients() {
    }
}

