/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.thrift.TApplicationExceptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractThriftMessageClassFinder
implements Supplier<Class<?>> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractThriftMessageClassFinder.class);

    AbstractThriftMessageClassFinder() {
    }

    @Nullable
    static Class<?> getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            logger.warn("Can't find a class: {}", (Object)className, (Object)ex);
            return null;
        }
    }

    @Nullable
    static Class<?> getMatchedClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (AbstractThriftMessageClassFinder.isTBase(clazz) && !AbstractThriftMessageClassFinder.isAbstract(clazz) && AbstractThriftMessageClassFinder.hasNoArgConstructor(clazz)) {
            return clazz;
        }
        if (AbstractThriftMessageClassFinder.isTApplicationException(clazz)) {
            return clazz;
        }
        if (AbstractThriftMessageClassFinder.isTApplicationExceptions(clazz)) {
            return TApplicationException.class;
        }
        return null;
    }

    static boolean isTBase(Class<?> clazz) {
        return TBase.class.isAssignableFrom(clazz);
    }

    private static boolean isTApplicationExceptions(Class<?> clazz) {
        return clazz == TApplicationExceptions.class;
    }

    private static boolean isTApplicationException(Class<?> clazz) {
        return TApplicationException.class.isAssignableFrom(clazz);
    }

    private static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    private static boolean hasNoArgConstructor(Class<?> clazz) {
        Constructor<?>[] allConstructors;
        for (Constructor<?> ctor : allConstructors = clazz.getConstructors()) {
            Class<?>[] pType = ctor.getParameterTypes();
            if (pType.length != 0) continue;
            return true;
        }
        return false;
    }
}

