/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.thrift;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingClient;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.InvalidResponseHeadersException;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.circuitbreaker.FailFastException;
import com.linecorp.armeria.client.thrift.ThriftClientOptions;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.CompletableRpcResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.thrift.ThriftCall;
import com.linecorp.armeria.common.thrift.ThriftReply;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.thrift.TApplicationExceptions;
import com.linecorp.armeria.internal.common.thrift.TByteBufTransport;
import com.linecorp.armeria.internal.common.thrift.ThriftFieldAccess;
import com.linecorp.armeria.internal.common.thrift.ThriftFunction;
import com.linecorp.armeria.internal.common.thrift.ThriftProtocolUtil;
import com.linecorp.armeria.internal.common.thrift.ThriftServiceMetadata;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

final class THttpClientDelegate
extends DecoratingClient<HttpRequest, HttpResponse, RpcRequest, RpcResponse>
implements RpcClient {
    private final AtomicInteger nextSeqId = new AtomicInteger();
    private final SerializationFormat serializationFormat;
    private final TProtocolFactory requestProtocolFactory;
    private final TProtocolFactory responseProtocolFactory;
    private final int maxStringLength;
    private final MediaType mediaType;
    private final Map<Class<?>, ThriftServiceMetadata> metadataMap = new ConcurrentHashMap();

    THttpClientDelegate(HttpClient httpClient, ClientOptions options, SerializationFormat serializationFormat) {
        super((Client)httpClient);
        int maxContainerLength;
        this.serializationFormat = serializationFormat;
        this.requestProtocolFactory = ThriftSerializationFormats.protocolFactory(serializationFormat, 0, 0);
        int maxStringLength = (Integer)options.get(ThriftClientOptions.MAX_RESPONSE_STRING_LENGTH);
        if (maxStringLength < 0) {
            maxStringLength = Ints.saturatedCast((long)options.maxResponseLength());
        }
        if ((maxContainerLength = ((Integer)options.get(ThriftClientOptions.MAX_RESPONSE_CONTAINER_LENGTH)).intValue()) < 0) {
            maxContainerLength = Ints.saturatedCast((long)options.maxResponseLength());
        }
        this.responseProtocolFactory = ThriftSerializationFormats.protocolFactory(serializationFormat, maxStringLength, maxContainerLength);
        this.maxStringLength = maxStringLength;
        this.mediaType = serializationFormat.mediaType();
    }

    public RpcResponse execute(ClientRequestContext ctx, RpcRequest call) {
        ThriftFunction func;
        int seqId = this.nextSeqId.incrementAndGet();
        String method = call.method();
        List args = call.params();
        CompletableRpcResponse reply = new CompletableRpcResponse();
        ctx.logBuilder().serializationFormat(this.serializationFormat);
        try {
            func = this.metadata(call.serviceType()).function(method);
            if (func == null) {
                throw new IllegalArgumentException("Thrift method not found: " + method);
            }
        }
        catch (Throwable cause2) {
            reply.completeExceptionally(cause2);
            return reply;
        }
        try {
            HttpResponse httpResponse;
            TMessage header = new TMessage(THttpClientDelegate.fullMethod(ctx, func.name()), func.messageType(), seqId);
            ByteBuf buf = ctx.alloc().buffer(128);
            try {
                TByteBufTransport outTransport = new TByteBufTransport(buf);
                TProtocol tProtocol = this.requestProtocolFactory.getProtocol((TTransport)outTransport);
                tProtocol.writeMessageBegin(header);
                TBase<?, ?> tArgs = func.newArgs(args);
                tArgs.write(tProtocol);
                tProtocol.writeMessageEnd();
                ctx.logBuilder().requestContent((Object)call, (Object)new ThriftCall(header, tArgs));
            }
            catch (Throwable t) {
                buf.release();
                Exceptions.throwUnsafely((Throwable)t);
            }
            HttpRequest httpReq = HttpRequest.of((RequestHeaders)RequestHeaders.builder((HttpMethod)HttpMethod.POST, (String)ctx.path()).scheme(ctx.sessionProtocol()).contentType(this.mediaType).build(), (HttpData)HttpData.wrap((ByteBuf)buf).withEndOfStream());
            ctx.updateRequest(httpReq);
            ctx.logBuilder().defer(RequestLogProperty.RESPONSE_CONTENT);
            try {
                httpResponse = (HttpResponse)((Client)this.unwrap()).execute(ctx, (Request)httpReq);
            }
            catch (Throwable t) {
                httpReq.abort();
                throw t;
            }
            ((CompletableFuture)httpResponse.aggregate(AggregationOptions.usePooledObjects((ByteBufAllocator)ctx.alloc(), (EventExecutor)ctx.eventLoop())).handle((res, cause) -> {
                if (cause != null) {
                    THttpClientDelegate.handlePreDecodeException(ctx, reply, func, Exceptions.peel((Throwable)cause));
                    return null;
                }
                try (HttpData content = res.content();){
                    HttpStatus status = res.status();
                    if (status.code() != HttpStatus.OK.code()) {
                        THttpClientDelegate.handlePreDecodeException(ctx, reply, func, (Throwable)new InvalidResponseHeadersException(res.headers()));
                        Object var9_10 = null;
                        return var9_10;
                    }
                    try {
                        this.handle(ctx, seqId, reply, func, content);
                    }
                    catch (Throwable t) {
                        THttpClientDelegate.handlePreDecodeException(ctx, reply, func, t);
                    }
                }
                return null;
            })).exceptionally(CompletionActions::log);
        }
        catch (Throwable cause3) {
            THttpClientDelegate.handlePreDecodeException(ctx, reply, func, cause3);
        }
        return reply;
    }

    private static String fullMethod(ClientRequestContext ctx, String method) {
        String service = ctx.fragment();
        if (Strings.isNullOrEmpty((String)service)) {
            return method;
        }
        return service + ':' + method;
    }

    private ThriftServiceMetadata metadata(Class<?> serviceType) {
        ThriftServiceMetadata metadata = this.metadataMap.get(serviceType);
        if (metadata != null) {
            return metadata;
        }
        return this.metadataMap.computeIfAbsent(serviceType, ThriftServiceMetadata::new);
    }

    private void handle(ClientRequestContext ctx, int seqId, CompletableRpcResponse reply, ThriftFunction func, HttpData content) throws TException {
        if (func.isOneWay()) {
            THttpClientDelegate.handleSuccess(ctx, reply, null, null);
            return;
        }
        if (content.isEmpty()) {
            throw new TApplicationException(5);
        }
        ByteBuf buf = content.byteBuf();
        ThriftProtocolUtil.maybeCheckMessageLength(this.serializationFormat, buf, this.maxStringLength);
        TByteBufTransport inputTransport = new TByteBufTransport(buf);
        TProtocol inputProtocol = this.responseProtocolFactory.getProtocol((TTransport)inputTransport);
        TMessage header = inputProtocol.readMessageBegin();
        TApplicationException appEx = THttpClientDelegate.readApplicationException(seqId, func, inputProtocol, header);
        if (appEx != null) {
            THttpClientDelegate.handleException(ctx, reply, new ThriftReply(header, appEx), (Exception)appEx);
            return;
        }
        TBase<?, ?> result = func.newResult();
        result.read(inputProtocol);
        inputProtocol.readMessageEnd();
        ThriftReply rawResponseContent = new ThriftReply(header, result);
        for (TFieldIdEnum fieldIdEnum : func.exceptionFields()) {
            if (!ThriftFieldAccess.isSet(result, fieldIdEnum)) continue;
            TException cause = (TException)((Object)ThriftFieldAccess.get(result, fieldIdEnum));
            THttpClientDelegate.handleException(ctx, reply, rawResponseContent, (Exception)((Object)cause));
            return;
        }
        TFieldIdEnum successField = func.successField();
        if (successField == null) {
            THttpClientDelegate.handleSuccess(ctx, reply, null, rawResponseContent);
            return;
        }
        if (ThriftFieldAccess.isSet(result, successField)) {
            Object returnValue = ThriftFieldAccess.get(result, successField);
            THttpClientDelegate.handleSuccess(ctx, reply, returnValue, rawResponseContent);
            return;
        }
        THttpClientDelegate.handleException(ctx, reply, rawResponseContent, (Exception)new TApplicationException(5, result.getClass().getName() + '.' + successField.getFieldName()));
    }

    @Nullable
    private static TApplicationException readApplicationException(int seqId, ThriftFunction func, TProtocol inputProtocol, TMessage msg) throws TException {
        if (msg.seqid != seqId) {
            throw new TApplicationException(4);
        }
        if (!func.name().equals(msg.name)) {
            return new TApplicationException(3, msg.name);
        }
        if (msg.type == 3) {
            TApplicationException appEx = TApplicationExceptions.read(inputProtocol);
            inputProtocol.readMessageEnd();
            return appEx;
        }
        return null;
    }

    private static void handleSuccess(ClientRequestContext ctx, CompletableRpcResponse reply, @Nullable Object returnValue, @Nullable ThriftReply rawResponseContent) {
        reply.complete(returnValue);
        ctx.logBuilder().responseContent((Object)reply, (Object)rawResponseContent);
    }

    private static void handleException(ClientRequestContext ctx, CompletableRpcResponse reply, @Nullable ThriftReply rawResponseContent, Exception cause) {
        reply.completeExceptionally((Throwable)cause);
        ctx.logBuilder().responseContent((Object)reply, (Object)rawResponseContent);
    }

    private static void handlePreDecodeException(ClientRequestContext ctx, CompletableRpcResponse reply, ThriftFunction thriftMethod, Throwable cause) {
        THttpClientDelegate.handleException(ctx, reply, null, THttpClientDelegate.decodeException(cause, thriftMethod.declaredExceptions()));
    }

    static Exception decodeException(Throwable cause, @Nullable Class<?>[] declaredThrowableExceptions) {
        if (cause instanceof TException || cause instanceof UnprocessedRequestException || cause instanceof FailFastException) {
            return (Exception)cause;
        }
        boolean isDeclaredException = declaredThrowableExceptions != null ? Arrays.stream(declaredThrowableExceptions).anyMatch(v -> v.isInstance(cause)) : false;
        if (isDeclaredException) {
            return (Exception)cause;
        }
        if (cause instanceof Error) {
            return new RuntimeException(cause);
        }
        return new TTransportException(cause);
    }
}

