/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.linecorp.armeria.internal.common.thrift.ThriftFunction;
import com.linecorp.armeria.internal.common.thrift.ThriftServiceMetadata;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ThriftServiceEntry {
    final String name;
    final Iterable<?> implementations;
    final ThriftServiceMetadata metadata;

    ThriftServiceEntry(Map.Entry<String, ? extends Iterable<?>> entry) {
        String name = entry.getKey();
        Iterable<?> implementations = entry.getValue();
        Objects.requireNonNull(name, "implementations contains an entry with null key.");
        Objects.requireNonNull(implementations, "implementations['" + name + "']");
        this.name = name;
        this.implementations = implementations;
        this.metadata = new ThriftServiceMetadata(implementations);
    }

    public String name() {
        return this.name;
    }

    public Iterable<?> implementations() {
        return this.implementations;
    }

    public Set<Class<?>> interfaces() {
        return this.metadata.interfaces();
    }

    public String functionName(String method) {
        ThriftFunction function = this.metadata.function(method);
        Objects.requireNonNull(function, "metadata.function(method) returned null. metadata: " + this.metadata + ", method: " + method);
        return function.name();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Entry").add("name", (Object)this.name()).add("ifaces", this.interfaces()).add("impl", this.implementations()).toString();
    }
}

