/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.thrift;

import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftMetadataAccess {
    private static final Logger logger;
    private static boolean preInitializeThriftClass;
    private static final String THRIFT_OPTIONS_PROPERTIES = "../../common/thrift/thrift-options.properties";

    @VisibleForTesting
    static boolean needsPreInitialization(Properties properties) {
        return "true".equals(properties.getProperty("struct.preinit"));
    }

    public static synchronized <T extends TBase<T, F>, F extends TFieldIdEnum> Map<? extends TFieldIdEnum, FieldMetaData> getStructMetaDataMap(Class<?> clazz) {
        if (preInitializeThriftClass) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                logger.trace("Unexpected exception while initializing class {}: ", clazz, (Object)e);
            }
        }
        return FieldMetaData.getStructMetaDataMap(clazz);
    }

    private ThriftMetadataAccess() {
    }

    static {
        block8: {
            logger = LoggerFactory.getLogger(ThriftMetadataAccess.class);
            try {
                URL url = ThriftMetadataAccess.class.getResource(THRIFT_OPTIONS_PROPERTIES);
                if (url != null) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                        Properties props = new Properties();
                        props.load(reader);
                        preInitializeThriftClass = ThriftMetadataAccess.needsPreInitialization(props);
                        break block8;
                    }
                }
                preInitializeThriftClass = true;
            }
            catch (Exception e) {
                logger.debug("Unexpected exception while extracting options: ", (Throwable)e);
                preInitializeThriftClass = true;
            }
        }
    }
}

