/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.linecorp.armeria.common.util.CompletionActions;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.thrift.async.AsyncMethodCallback;

public final class AsyncMethodCallbacks {
    public static <T> void transfer(CompletionStage<T> src, AsyncMethodCallback<? super T> dest) {
        Objects.requireNonNull(src, "src");
        Objects.requireNonNull(dest, "dest");
        src.handle((res, cause) -> {
            try {
                if (cause != null) {
                    AsyncMethodCallbacks.invokeOnError(dest, cause);
                } else {
                    dest.onComplete(res);
                }
            }
            catch (Exception e) {
                CompletionActions.log((Throwable)e);
            }
            return null;
        });
    }

    public static void invokeOnError(AsyncMethodCallback<?> callback, Throwable cause) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(cause, "cause");
        if (cause instanceof Exception) {
            callback.onError((Exception)cause);
        } else {
            callback.onError((Exception)new CompletionException(cause.toString(), cause));
        }
    }

    private AsyncMethodCallbacks() {
    }
}

