/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.thrift.ThriftJacksonSerializers;
import com.linecorp.armeria.common.thrift.ThriftMessage;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TMessage;

@JsonSerialize(using=ThriftJacksonSerializers.ThriftCallJsonSerializer.class)
public final class ThriftCall
extends ThriftMessage {
    private final TBase<?, ?> args;

    public ThriftCall(TMessage header, TBase<?, ?> args) {
        super(header);
        if (header.type != 1 && header.type != 4) {
            throw new IllegalArgumentException("header.type: " + ThriftCall.typeStr(header.type) + " (expected: CALL or ONEWAY)");
        }
        this.args = Objects.requireNonNull(args, "args");
    }

    public TBase<?, ?> args() {
        return this.args;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThriftCall)) {
            return false;
        }
        return super.equals(o) && this.args.equals(((ThriftCall)o).args);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.args.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("seqId", this.header().seqid).add("type", (Object)this.typeStr()).add("name", (Object)this.header().name).add("args", this.args).toString();
    }
}

