/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.thrift.text.AbstractThriftMessageClassFinder;
import com.linecorp.armeria.common.thrift.text.DefaultThriftMessageClassFinder;
import com.linecorp.armeria.common.thrift.text.PairContext;
import com.linecorp.armeria.common.thrift.text.StackWalkingThriftMessageClassFinder;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StructContext
extends PairContext {
    private static final Logger log = LoggerFactory.getLogger(StructContext.class);
    private static final Supplier<Class<?>> thriftMessageClassFinder;
    private static final Map<String, Class<?>> fieldMetaDataClassCache;
    private final Map<String, TField> fieldNameMap;
    private final Map<String, Class<?>> classMap = new HashMap();

    StructContext(@Nullable JsonNode json) {
        this(json, StructContext.getCurrentThriftMessageClass());
    }

    StructContext(@Nullable JsonNode json, Class<?> clazz) {
        super(json);
        this.fieldNameMap = this.computeFieldNameMap(clazz);
    }

    @Override
    protected TField getTFieldByName(String name) throws TException {
        if (!this.fieldNameMap.containsKey(name)) {
            throw new TException("Unknown field: " + name);
        }
        return this.fieldNameMap.get(name);
    }

    @Override
    @Nullable
    protected Class<?> getClassByFieldName(String fieldName) {
        return this.classMap.get(fieldName);
    }

    private static Class<?> getCurrentThriftMessageClass() {
        Class<?> clazz = thriftMessageClassFinder.get();
        if (clazz == null) {
            throw new RuntimeException("Must call (indirectly) from a TBase/TApplicationException object.");
        }
        return clazz;
    }

    private Map<String, TField> computeFieldNameMap(Class<?> clazz) {
        HashMap<String, TField> map = new HashMap<String, TField>();
        if (AbstractThriftMessageClassFinder.isTBase(clazz)) {
            Map metaDataMap = FieldMetaData.getStructMetaDataMap(clazz);
            for (Map.Entry e : metaDataMap.entrySet()) {
                String fieldName = ((TFieldIdEnum)e.getKey()).getFieldName();
                FieldMetaData metaData = (FieldMetaData)e.getValue();
                this.updateClassMap(metaData, clazz);
                byte type = 16 == metaData.valueMetaData.type ? (byte)8 : (byte)metaData.valueMetaData.type;
                map.put(fieldName, new TField(fieldName, type, ((TFieldIdEnum)e.getKey()).getThriftFieldId()));
            }
        } else {
            map.put("message", new TField("message", 11, 1));
            map.put("type", new TField("type", 8, 2));
        }
        return map;
    }

    private void updateClassMap(FieldMetaData metaData, Class<?> clazz) {
        FieldValueMetaData elementMetaData;
        String fieldName = metaData.fieldName;
        if (metaData.valueMetaData.isContainer()) {
            if (metaData.valueMetaData instanceof SetMetaData) {
                elementMetaData = ((SetMetaData)metaData.valueMetaData).elemMetaData;
            } else if (metaData.valueMetaData instanceof ListMetaData) {
                elementMetaData = ((ListMetaData)metaData.valueMetaData).elemMetaData;
            } else {
                if (metaData.valueMetaData instanceof MapMetaData) {
                    MapMetaData mapMetaData = (MapMetaData)metaData.valueMetaData;
                    boolean req = true;
                    FieldMetaData keyMetaData = new FieldMetaData(fieldName + "$k", 1, mapMetaData.keyMetaData);
                    this.updateClassMap(keyMetaData, clazz);
                    FieldMetaData valueMetaData = new FieldMetaData(fieldName + "$v", 1, mapMetaData.valueMetaData);
                    this.updateClassMap(valueMetaData, clazz);
                    return;
                }
                elementMetaData = metaData.valueMetaData;
            }
        } else {
            elementMetaData = metaData.valueMetaData;
        }
        if (elementMetaData instanceof EnumMetaData) {
            this.classMap.put(fieldName, ((EnumMetaData)elementMetaData).enumClass);
        } else if (elementMetaData instanceof StructMetaData) {
            this.classMap.put(fieldName, ((StructMetaData)elementMetaData).structClass);
        } else {
            String typedefName = elementMetaData.getTypedefName();
            if (typedefName != null) {
                String fqcn = clazz.getPackage().getName() + '.' + typedefName;
                Class fieldClass = fieldMetaDataClassCache.get(fqcn);
                if (fieldClass == null) {
                    fieldClass = fieldMetaDataClassCache.computeIfAbsent(fqcn, key -> {
                        try {
                            return Class.forName(key);
                        }
                        catch (ClassNotFoundException ignored) {
                            return StructContext.class;
                        }
                    });
                }
                if (fieldClass != StructContext.class) {
                    this.classMap.put(fieldName, fieldClass);
                }
            }
        }
    }

    static {
        fieldMetaDataClassCache = new MapMaker().weakValues().makeMap();
        AbstractThriftMessageClassFinder supplier = null;
        if (SystemInfo.javaVersion() >= 9) {
            try {
                supplier = new StackWalkingThriftMessageClassFinder();
            }
            catch (Throwable t) {
                log.warn("Failed to initialize StackWalkingThriftMessageClassFinder. Falling back to DefaultThriftMessageClassFinder:", t);
            }
        }
        thriftMessageClassFinder = supplier != null ? supplier : new DefaultThriftMessageClassFinder();
    }
}

