/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.linecorp.armeria.common.thrift.ThriftCall;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactories;
import com.linecorp.armeria.common.thrift.ThriftReply;
import com.linecorp.armeria.common.util.Exceptions;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TTransport;

final class ThriftJacksonSerializers
extends Serializers.Base
implements Serializable {
    private static final long serialVersionUID = -285900387635271875L;
    private final boolean useNamedEnums;

    ThriftJacksonSerializers(boolean useNamedEnums) {
        this.useNamedEnums = useNamedEnums;
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class rawType = type.getRawClass();
        if (TMessage.class.isAssignableFrom(rawType)) {
            return new TMessageJsonSerializer();
        }
        if (TBase.class.isAssignableFrom(rawType)) {
            return new TBaseJsonSerializer(this.useNamedEnums);
        }
        if (TApplicationException.class.isAssignableFrom(rawType)) {
            return new TApplicationExceptionJsonSerializer(this.useNamedEnums);
        }
        if (ThriftCall.class.isAssignableFrom(rawType)) {
            return new ThriftCallJsonSerializer(this.useNamedEnums);
        }
        if (ThriftReply.class.isAssignableFrom(rawType)) {
            return new ThriftReplyJsonSerializer(this.useNamedEnums);
        }
        return super.findSerializer(config, type, beanDesc);
    }

    static void serializeTMessage(TMessage value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", value.name);
        gen.writeNumberField("type", (short)value.type);
        gen.writeNumberField("seqid", value.seqid);
        gen.writeEndObject();
    }

    static void serializeTBase(@Nullable TBase value, JsonGenerator gen, boolean useNamedEnums) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        gen.writeRawValue(ThriftJacksonSerializers.serializeTBaseLike(protocol -> {
            try {
                value.write(protocol);
            }
            catch (TException ex) {
                throw new IllegalArgumentException(ex);
            }
        }, useNamedEnums));
    }

    static void serializeTApplicationException(@Nullable TApplicationException value, JsonGenerator gen, boolean useNamedEnums) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        gen.writeRawValue(ThriftJacksonSerializers.serializeTBaseLike(protocol -> {
            try {
                value.write(protocol);
            }
            catch (TException ex) {
                throw new IllegalArgumentException(ex);
            }
        }, useNamedEnums));
    }

    private static String serializeTBaseLike(Consumer<TProtocol> writer, boolean useNamedEnums) {
        TMemoryBuffer buffer;
        try {
            buffer = new TMemoryBuffer(1024);
        }
        catch (Exception ex) {
            return (String)Exceptions.throwUnsafely((Throwable)ex);
        }
        TProtocolFactory factory = useNamedEnums ? ThriftProtocolFactories.TEXT_NAMED_ENUM : ThriftProtocolFactories.TEXT;
        TProtocol protocol = factory.getProtocol((TTransport)buffer);
        writer.accept(protocol);
        return new String(buffer.getArray(), 0, buffer.length());
    }

    static final class TMessageJsonSerializer
    extends StdSerializer<TMessage> {
        private static final long serialVersionUID = 9105150745657053783L;

        TMessageJsonSerializer() {
            super(TMessage.class);
        }

        public void serialize(TMessage value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ThriftJacksonSerializers.serializeTMessage(value, gen);
        }
    }

    private static final class TBaseJsonSerializer
    extends StdSerializer<TBase> {
        private static final long serialVersionUID = -7954242119098597530L;
        private final boolean useNamedEnums;

        TBaseJsonSerializer() {
            this(false);
        }

        TBaseJsonSerializer(boolean useNamedEnums) {
            super(TBase.class);
            this.useNamedEnums = useNamedEnums;
        }

        public void serialize(TBase value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ThriftJacksonSerializers.serializeTBase(value, gen, this.useNamedEnums);
        }
    }

    private static final class TApplicationExceptionJsonSerializer
    extends StdSerializer<TApplicationException> {
        private static final long serialVersionUID = -7552338111791933510L;
        private final boolean useNamedEnums;

        TApplicationExceptionJsonSerializer() {
            this(false);
        }

        TApplicationExceptionJsonSerializer(boolean useNamedEnums) {
            super(TApplicationException.class);
            this.useNamedEnums = useNamedEnums;
        }

        public void serialize(TApplicationException value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            ThriftJacksonSerializers.serializeTApplicationException(value, gen, this.useNamedEnums);
        }
    }

    static final class ThriftCallJsonSerializer
    extends StdSerializer<ThriftCall> {
        private static final long serialVersionUID = -4873295256482417316L;
        private final boolean useNamedEnums;

        ThriftCallJsonSerializer() {
            this(false);
        }

        ThriftCallJsonSerializer(boolean useNamedEnums) {
            super(ThriftCall.class);
            this.useNamedEnums = useNamedEnums;
        }

        public void serialize(ThriftCall value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("header");
            ThriftJacksonSerializers.serializeTMessage(value.header(), gen);
            gen.writeFieldName("args");
            ThriftJacksonSerializers.serializeTBase(value.args(), gen, this.useNamedEnums);
            gen.writeEndObject();
        }
    }

    static final class ThriftReplyJsonSerializer
    extends StdSerializer<ThriftReply> {
        private static final long serialVersionUID = -783551224966265113L;
        private final boolean useNamedEnums;

        ThriftReplyJsonSerializer() {
            this(false);
        }

        ThriftReplyJsonSerializer(boolean useNamedEnums) {
            super(ThriftReply.class);
            this.useNamedEnums = useNamedEnums;
        }

        public void serialize(ThriftReply value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            TApplicationException exception;
            TBase<?, ?> result;
            if (value == null) {
                gen.writeNull();
                return;
            }
            gen.writeStartObject();
            gen.writeFieldName("header");
            ThriftJacksonSerializers.serializeTMessage(value.header(), gen);
            if (value.isException()) {
                result = null;
                exception = value.exception();
            } else {
                result = value.result();
                exception = null;
            }
            gen.writeFieldName("result");
            ThriftJacksonSerializers.serializeTBase(result, gen, this.useNamedEnums);
            gen.writeFieldName("exception");
            ThriftJacksonSerializers.serializeTApplicationException(exception, gen, this.useNamedEnums);
            gen.writeEndObject();
        }
    }
}

