/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.linecorp.armeria.common.thrift.text.AbstractThriftMessageClassFinder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StackWalkingThriftMessageClassFinder
extends AbstractThriftMessageClassFinder {
    private static final Logger logger = LoggerFactory.getLogger(StackWalkingThriftMessageClassFinder.class);
    private static final String INVOKING_FAIL_MSG = "Failed to invoke StackWalker.StackFrame.getDeclaringClass():";
    @Nullable
    private final Function<Stream<Object>, Class<?>> walkHandler;
    private final MethodHandle walkMH;
    private final Object stackWalker;

    StackWalkingThriftMessageClassFinder() throws Throwable {
        Function<Object, Class> getClassByStackFrameTemp;
        Object instance;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> stackWalkerClass = classLoader.loadClass("java.lang.StackWalker");
        this.walkMH = lookup.findVirtual(stackWalkerClass, "walk", MethodType.methodType(Object.class, Function.class));
        Class<?> stackFrameClass = classLoader.loadClass("java.lang.StackWalker$StackFrame");
        try {
            Class<?> Option = classLoader.loadClass("java.lang.StackWalker$Option");
            MethodHandle getInstanceMH = lookup.findStatic(stackWalkerClass, "getInstance", MethodType.methodType(stackWalkerClass, Option));
            Enum RETAIN_CLASS_REFERENCE = Arrays.stream((Enum[])Option.getEnumConstants()).filter(op -> "RETAIN_CLASS_REFERENCE".equals(op.name())).findFirst().orElse(null);
            if (RETAIN_CLASS_REFERENCE == null) {
                throw new IllegalStateException("Failed to get RETAIN_CLASS_REFERENCE option");
            }
            instance = getInstanceMH.invoke(RETAIN_CLASS_REFERENCE);
            MethodHandle getDeclaringClassMH = lookup.findVirtual(stackFrameClass, "getDeclaringClass", MethodType.methodType(Class.class));
            getClassByStackFrameTemp = stackFrame -> {
                try {
                    return StackWalkingThriftMessageClassFinder.getMatchedClass(getDeclaringClassMH.invoke(stackFrame));
                }
                catch (Throwable t) {
                    logger.warn(INVOKING_FAIL_MSG, t);
                    return null;
                }
            };
        }
        catch (Throwable throwable) {
            logger.warn("Falling back to StackWalker without option:", throwable);
            MethodHandle getInstanceMH = lookup.findStatic(stackWalkerClass, "getInstance", MethodType.methodType(stackWalkerClass));
            MethodHandle getClassNameMH = lookup.findVirtual(stackFrameClass, "getClassName", MethodType.methodType(String.class));
            instance = getInstanceMH.invoke();
            getClassByStackFrameTemp = stackFrame -> {
                try {
                    return StackWalkingThriftMessageClassFinder.getMatchedClass(StackWalkingThriftMessageClassFinder.getClassByName(getClassNameMH.invoke(stackFrame).toString()));
                }
                catch (Throwable t) {
                    logger.warn(INVOKING_FAIL_MSG, t);
                    return null;
                }
            };
        }
        this.stackWalker = instance;
        Function<Object, Class> getClassByStackFrame = getClassByStackFrameTemp;
        this.walkHandler = stackFrameStream -> stackFrameStream.map(getClassByStackFrame).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Class<?> get() {
        try {
            return this.walkMH.invoke(this.stackWalker, this.walkHandler);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to invoke StackWalker.walk():", t);
        }
    }
}

