/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.thrift;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DecoratingClientFactory;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.thrift.THttpClient;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.internal.client.thrift.DefaultTHttpClient;
import com.linecorp.armeria.internal.client.thrift.THttpClientDelegate;
import com.linecorp.armeria.internal.client.thrift.THttpClientInvocationHandler;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Set;

final class THttpClientFactory
extends DecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES;

    THttpClientFactory(ClientFactory httpClientFactory) {
        super(httpClientFactory);
    }

    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public Object newClient(ClientBuilderParams params) {
        this.validateParams(params);
        Class clientType = params.clientType();
        ClientOptions options = params.options();
        RpcClient delegate = options.decoration().rpcDecorate((RpcClient)new THttpClientDelegate(this.newHttpClient(params), params.scheme().serializationFormat()));
        if (clientType == THttpClient.class) {
            return new DefaultTHttpClient(params, delegate, this.meterRegistry());
        }
        ClientBuilderParams delegateParams = ClientBuilderParams.of((Scheme)params.scheme(), (EndpointGroup)params.endpointGroup(), (String)"/", THttpClient.class, (ClientOptions)options);
        DefaultTHttpClient thriftClient = new DefaultTHttpClient(delegateParams, delegate, this.meterRegistry());
        return Proxy.newProxyInstance(clientType.getClassLoader(), new Class[]{clientType}, (InvocationHandler)new THttpClientInvocationHandler(params, thriftClient));
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SessionProtocol p : SessionProtocol.values()) {
            for (SerializationFormat f : ThriftSerializationFormats.values()) {
                builder.add((Object)Scheme.of((SerializationFormat)f, (SessionProtocol)p));
            }
        }
        SUPPORTED_SCHEMES = builder.build();
    }
}

