/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.tomcat;

import com.linecorp.armeria.common.HttpData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Queue;
import org.apache.coyote.OutputBuffer;
import org.apache.tomcat.util.buf.ByteChunk;

public final class Tomcat90OutputBuffer
implements OutputBuffer {
    private final Queue<HttpData> data;
    private long bytesWritten;

    public Tomcat90OutputBuffer(Queue<HttpData> data) {
        this.data = data;
    }

    public int doWrite(ByteChunk chunk) {
        int start = chunk.getStart();
        int end = chunk.getEnd();
        int length = end - start;
        if (length == 0) {
            return 0;
        }
        byte[] content = Arrays.copyOfRange(chunk.getBuffer(), start, end);
        this.data.add(HttpData.wrap((byte[])content));
        this.bytesWritten += (long)length;
        return length;
    }

    public int doWrite(ByteBuffer chunk) throws IOException {
        int length = chunk.remaining();
        if (length <= 0) {
            return 0;
        }
        byte[] content = new byte[chunk.remaining()];
        chunk.get(content);
        this.data.add(HttpData.wrap((byte[])content));
        this.bytesWritten += (long)length;
        return length;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

