/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.tomcat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.util.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TomcatVersion {
    private static final Logger logger = LoggerFactory.getLogger(TomcatVersion.class);
    private static final int TOMCAT_MAJOR_VERSION;
    private static final int TOMCAT_MINOR_VERSION;

    public static int major() {
        return TOMCAT_MAJOR_VERSION;
    }

    public static int minor() {
        return TOMCAT_MINOR_VERSION;
    }

    private TomcatVersion() {
    }

    static {
        Pattern pattern = Pattern.compile("^([1-9][0-9]*)\\.(0|[1-9][0-9]*)\\.");
        String version = ServerInfo.getServerNumber();
        Matcher matcher = pattern.matcher(version);
        int tomcatMajorVersion = -1;
        int tomcatMinorVersion = -1;
        if (matcher.find()) {
            try {
                tomcatMajorVersion = Integer.parseInt(matcher.group(1));
                tomcatMinorVersion = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TOMCAT_MAJOR_VERSION = tomcatMajorVersion;
        TOMCAT_MINOR_VERSION = tomcatMinorVersion;
        if (TOMCAT_MAJOR_VERSION > 0) {
            logger.info("Tomcat version: {} ({}.{})", new Object[]{version, TOMCAT_MAJOR_VERSION, TOMCAT_MINOR_VERSION});
        } else {
            logger.info("Tomcat version: {} (unknown)", (Object)version);
        }
    }
}

