/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.server.tomcat.JarSubsetResourceSet;
import com.linecorp.armeria.server.tomcat.TomcatServiceConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.JarResourceSet;
import org.apache.catalina.webresources.StandardRoot;

final class ArmeriaWebResourceRoot
extends StandardRoot {
    private final TomcatServiceConfig config;

    ArmeriaWebResourceRoot(Context context, TomcatServiceConfig config) {
        super(context);
        this.config = config;
    }

    protected WebResourceSet createMainResourceSet() {
        Path docBase = this.config.docBase();
        assert (docBase.isAbsolute());
        String docBaseStr = docBase.toString();
        this.getContext().setDocBase(docBaseStr);
        if (Files.isDirectory(docBase, new LinkOption[0])) {
            return new DirResourceSet((WebResourceRoot)this, "/", docBaseStr, "/");
        }
        String jarRoot = this.config.jarRoot();
        if (jarRoot != null) {
            if ("/".equals(jarRoot)) {
                return new JarResourceSet((WebResourceRoot)this, "/", docBaseStr, "/");
            }
            return new JarSubsetResourceSet((WebResourceRoot)this, "/", docBaseStr, "/", jarRoot);
        }
        throw new IllegalArgumentException(sm.getString("standardRoot.startInvalidMain", new Object[]{docBaseStr}));
    }
}

