/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.tomcat.TomcatService;
import com.linecorp.armeria.server.tomcat.TomcatServiceException;
import com.linecorp.armeria.server.tomcat.TomcatUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ManagedTomcatService
extends TomcatService {
    private static final Logger logger = LoggerFactory.getLogger(ManagedTomcatService.class);
    private static final Set<LifecycleState> TOMCAT_START_STATES = Sets.immutableEnumSet((Enum)LifecycleState.STARTED, (Enum[])new LifecycleState[]{LifecycleState.STARTING, LifecycleState.STARTING_PREP});
    private final Function<String, Connector> connectorFactory;
    private final Consumer<Connector> postStopTask;
    private final ServerListener configurator;
    private static final Set<String> activeEngines = new HashSet<String>();
    @Nullable
    private org.apache.catalina.Server server;
    @Nullable
    private Server armeriaServer;
    @Nullable
    private String hostName;
    @Nullable
    private Connector connector;
    @Nullable
    private String engineName;
    private boolean started;

    ManagedTomcatService(@Nullable String hostName, Function<String, Connector> connectorFactory, Consumer<Connector> postStopTask) {
        this.hostName = hostName;
        this.connectorFactory = connectorFactory;
        this.postStopTask = postStopTask;
        this.configurator = new Configurator();
    }

    public void serviceAdded(ServiceConfig cfg) throws Exception {
        if (this.hostName == null) {
            this.hostName = cfg.server().defaultHostname();
        }
        if (this.armeriaServer != null) {
            if (this.armeriaServer != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.armeriaServer = cfg.server();
        this.armeriaServer.addListener(this.configurator);
    }

    void start() throws Exception {
        assert (this.hostName() != null);
        this.started = false;
        this.connector = this.connectorFactory.apply(this.hostName());
        Service service = this.connector.getService();
        Engine engine = TomcatUtil.engine(service, this.hostName());
        String engineName = engine.getName();
        if (activeEngines.contains(engineName)) {
            throw new TomcatServiceException("duplicate engine name: " + engineName);
        }
        this.server = service.getServer();
        if (TOMCAT_START_STATES.contains(this.server.getState())) {
            throw new TomcatServiceException("Cannot manage already running server: " + engineName);
        }
        logger.info("Starting an embedded Tomcat: {}", (Object)ManagedTomcatService.toString(this.server));
        this.server.start();
        this.started = true;
        activeEngines.add(engineName);
        this.engineName = engineName;
    }

    void stop() throws Exception {
        org.apache.catalina.Server server = this.server;
        Connector connector = this.connector;
        this.server = null;
        this.connector = null;
        if (this.engineName != null) {
            activeEngines.remove(this.engineName);
            this.engineName = null;
        }
        if (server == null || !this.started) {
            return;
        }
        try {
            logger.info("Stopping an embedded Tomcat: {}", (Object)ManagedTomcatService.toString(server));
            server.stop();
        }
        catch (Exception e) {
            logger.warn("Failed to stop an embedded Tomcat: {}", (Object)ManagedTomcatService.toString(server), (Object)e);
        }
        this.postStopTask.accept(connector);
    }

    @Override
    public Connector connector() {
        return this.connector;
    }

    @Override
    String hostName() {
        return this.hostName;
    }

    private final class Configurator
    extends ServerListenerAdapter {
        private Configurator() {
        }

        public void serverStarting(Server server) throws Exception {
            ManagedTomcatService.this.start();
        }

        public void serverStopped(Server server) throws Exception {
            ManagedTomcatService.this.stop();
        }
    }
}

