/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardServer;

final class TomcatServiceConfig {
    private final String serviceName;
    @Nullable
    private final String engineName;
    private final Path baseDir;
    private final Realm realm;
    @Nullable
    private final String hostname;
    private final Path docBase;
    @Nullable
    private final String jarRoot;
    private final List<Consumer<? super StandardServer>> configurators;

    TomcatServiceConfig(String serviceName, @Nullable String engineName, Path baseDir, Realm realm, @Nullable String hostname, Path docBase, @Nullable String jarRoot, List<Consumer<? super StandardServer>> configurators) {
        this.engineName = engineName;
        this.serviceName = serviceName;
        this.baseDir = baseDir;
        this.realm = realm;
        this.hostname = hostname;
        this.docBase = docBase;
        this.jarRoot = jarRoot;
        this.configurators = configurators;
    }

    String serviceName() {
        return this.serviceName;
    }

    String engineName() {
        return (String)MoreObjects.firstNonNull((Object)this.engineName, (Object)this.serviceName);
    }

    Path baseDir() {
        return this.baseDir;
    }

    Realm realm() {
        return this.realm;
    }

    @Nullable
    String hostname() {
        return this.hostname;
    }

    Path docBase() {
        return this.docBase;
    }

    @Nullable
    String jarRoot() {
        return this.jarRoot;
    }

    List<Consumer<? super StandardServer>> configurators() {
        return this.configurators;
    }

    public String toString() {
        return TomcatServiceConfig.toString(this, this.serviceName(), this.engineName(), this.baseDir(), this.realm(), this.hostname(), this.docBase(), this.jarRoot());
    }

    static String toString(Object holder, String serviceName, @Nullable String engineName, @Nullable Path baseDir, @Nullable Realm realm, @Nullable String hostname, Path docBase, @Nullable String jarRoot) {
        return holder.getClass().getSimpleName() + "(serviceName: " + serviceName + ", engineName: " + engineName + ", baseDir: " + baseDir + ", realm: " + (realm != null ? realm.getClass().getSimpleName() : "null") + ", hostname: " + hostname + ", docBase: " + docBase + (jarRoot != null ? ", jarRoot: " + jarRoot : "") + ')';
    }
}

