/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipFile;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.realm.NullRealm;
import org.apache.catalina.startup.Tomcat;

final class TomcatUtil {
    private static final LifecycleListener defaultWebXmlListener = new Tomcat.DefaultWebXmlListener();

    static URL getWebAppConfigFile(final String contextPath, final Path docBase) {
        final AtomicReference configUrlRef = new AtomicReference();
        new Tomcat(){
            {
                configUrlRef.set(this.getWebappConfigFile(docBase.toString(), contextPath));
            }
        };
        return (URL)configUrlRef.get();
    }

    static String noDefaultWebXmlPath() {
        return "org/apache/catalina/startup/NO_DEFAULT_XML";
    }

    static LifecycleListener getDefaultWebXmlListener() {
        return defaultWebXmlListener;
    }

    static Engine engine(Service service, String hostname) {
        Engine engine;
        try {
            Method m = Service.class.getDeclaredMethod("getContainer", new Class[0]);
            engine = (Engine)m.invoke((Object)service, new Object[0]);
        }
        catch (Exception e) {
            throw new Error("failed to invoke Service.getContainer()", e);
        }
        if (engine != null) {
            return engine;
        }
        StandardEngine newEngine = new StandardEngine();
        newEngine.setName("Tomcat");
        newEngine.setDefaultHost(hostname);
        newEngine.setRealm((Realm)new NullRealm());
        service.setContainer((Engine)newEngine);
        return newEngine;
    }

    static boolean isZip(Path path) {
        boolean bl;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        ZipFile ignored = new ZipFile(path.toFile());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored2) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    private TomcatUtil() {
    }
}

