/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.JarResourceSet;

final class JarSubsetResourceSet
extends JarResourceSet {
    private static final MethodHandle archiveEntriesGetter;
    private static final MethodHandle archiveEntriesSetter;
    private final String prefix;

    JarSubsetResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath, String jarRoot) {
        super(root, webAppMount, base, internalPath);
        assert (!"/".equals(jarRoot)) : "JarResourceSet should be used instead.";
        assert (jarRoot.startsWith("/")) : "jarRoot must be absolute.";
        assert (!jarRoot.endsWith("/")) : "jarRoot must not end with '/'.";
        this.prefix = jarRoot.substring(1) + '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected HashMap<String, JarEntry> getArchiveEntries(boolean single) {
        Object object = this.archiveLock;
        synchronized (object) {
            Map<String, JarEntry> archiveEntries = this.mhGetArchiveEntries();
            if (archiveEntries == null && !single) {
                JarFile jarFile = null;
                archiveEntries = new HashMap<String, JarEntry>();
                this.mhSetArchiveEntries(archiveEntries);
                try {
                    jarFile = this.openJarFile();
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith(this.prefix)) continue;
                        archiveEntries.put(name.substring(this.prefix.length()), entry);
                    }
                }
                catch (IOException ioe) {
                    this.mhSetArchiveEntries(null);
                    throw new IllegalStateException(ioe);
                }
                finally {
                    if (jarFile != null) {
                        this.closeJarFile();
                    }
                }
            }
            if (archiveEntries == null) {
                return null;
            }
            if (archiveEntries instanceof HashMap) {
                return (HashMap)archiveEntries;
            }
            return new HashMap<String, JarEntry>(archiveEntries);
        }
    }

    @Nullable
    private Map<String, JarEntry> mhGetArchiveEntries() {
        try {
            return archiveEntriesGetter.invoke(this);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private void mhSetArchiveEntries(@Nullable Map<String, JarEntry> archiveEntries) {
        try {
            archiveEntriesSetter.invoke(this, archiveEntries);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    protected JarEntry getArchiveEntry(String pathInArchive) {
        JarFile jarFile = null;
        try {
            jarFile = this.openJarFile();
            JarEntry jarEntry = jarFile.getJarEntry(this.prefix + pathInArchive);
            return jarEntry;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            if (jarFile != null) {
                this.closeJarFile();
            }
        }
    }

    static {
        MethodHandle getter = null;
        MethodHandle setter = null;
        try {
            Field field = AbstractArchiveResourceSet.class.getDeclaredField("archiveEntries");
            getter = MethodHandles.lookup().unreflectGetter(field);
            setter = MethodHandles.lookup().unreflectSetter(field);
        }
        catch (Exception e) {
            Exceptions.throwUnsafely((Throwable)e);
        }
        assert (getter != null);
        assert (setter != null);
        archiveEntriesGetter = getter;
        archiveEntriesSetter = setter;
    }
}

