/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.tomcat;

import com.linecorp.armeria.common.HttpData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.InputBuffer;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.ApplicationBufferHandler;

public final class Tomcat90InputBuffer
implements InputBuffer {
    private final HttpData content;
    private boolean read;

    public Tomcat90InputBuffer(HttpData content) {
        this.content = content;
    }

    public int doRead(ByteChunk chunk) {
        if (!this.isNeedToRead()) {
            return -1;
        }
        this.read = true;
        byte[] array = this.content.array();
        chunk.setBytes(array, 0, array.length);
        return array.length;
    }

    public int doRead(ApplicationBufferHandler handler) throws IOException {
        if (!this.isNeedToRead()) {
            return -1;
        }
        this.read = true;
        ByteBuf buf = this.content.byteBuf();
        ByteBuffer nioBuf = buf.nioBufferCount() == 1 ? buf.nioBuffer() : ByteBuffer.wrap(this.content.array());
        handler.setByteBuffer(nioBuf);
        return nioBuf.remaining();
    }

    public int available() {
        return this.content.length();
    }

    private boolean isNeedToRead() {
        return !this.read && !this.content.isEmpty();
    }
}

