/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.server.tomcat.ArmeriaWebResourceRoot;
import com.linecorp.armeria.server.tomcat.TomcatService;
import com.linecorp.armeria.server.tomcat.TomcatServiceConfig;
import com.linecorp.armeria.server.tomcat.TomcatServiceException;
import com.linecorp.armeria.server.tomcat.TomcatUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.startup.ContextConfig;

final class ManagedConnectorFactory
implements Function<String, Connector> {
    private static final String ROOT_CONTEXT_PATH = "";
    private static final int EMBEDDED_TOMCAT_PORT = -2;
    private final TomcatServiceConfig config;

    ManagedConnectorFactory(TomcatServiceConfig config) {
        this.config = config;
    }

    @Override
    public Connector apply(String hostname) {
        Class<?> protocolType = TomcatService.PROTOCOL_HANDLER_CLASS;
        Connector connector = new Connector(protocolType.getName());
        connector.setPort(0);
        StandardServer server = this.newServer(hostname, connector, this.config);
        Service service = server.findServices()[0];
        Engine engine = TomcatUtil.engine(service, hostname);
        StandardHost host = (StandardHost)engine.findChildren()[0];
        Context context = (Context)host.findChildren()[0];
        try {
            this.config.configurators().forEach(c -> c.accept(server));
        }
        catch (Throwable t) {
            throw new TomcatServiceException("failed to configure an embedded Tomcat", t);
        }
        this.checkConfiguration(server, service, connector, engine, host, context);
        assert (connector.getService().getServer() != null);
        return connector;
    }

    private StandardServer newServer(String hostname, Connector connector, TomcatServiceConfig config) {
        Context ctx;
        StandardEngine engine = new StandardEngine();
        engine.setName(config.engineName());
        engine.setDefaultHost(hostname);
        engine.setRealm(config.realm());
        engine.setBackgroundProcessorDelay(-1);
        StandardService service = new StandardService();
        service.setName(config.serviceName());
        service.setContainer((Engine)engine);
        service.addConnector(connector);
        StandardServer server = new StandardServer();
        File baseDir = config.baseDir().toFile();
        server.setCatalinaBase(baseDir);
        server.setCatalinaHome(baseDir);
        server.setPort(-2);
        server.addService((Service)service);
        StandardHost host = (StandardHost)engine.findChild(hostname);
        if (host == null) {
            host = new StandardHost();
            host.setName(hostname);
            engine.addChild((Container)host);
        }
        if (!host.getAppBaseFile().mkdirs()) {
            throw new TomcatServiceException("failed to create app base file: " + host.getAppBaseFile());
        }
        try {
            ctx = (Context)Class.forName(host.getContextClass(), true, this.getClass().getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TomcatServiceException("failed to create a new context: " + config, e);
        }
        ctx.setResources((WebResourceRoot)new ArmeriaWebResourceRoot(ctx, config));
        ctx.setPath(ROOT_CONTEXT_PATH);
        ctx.setDocBase(config.docBase().toString());
        ctx.addLifecycleListener(TomcatUtil.getDefaultWebXmlListener());
        ctx.setConfigFile(TomcatUtil.getWebAppConfigFile(ROOT_CONTEXT_PATH, config.docBase()));
        ContextConfig ctxCfg = new ContextConfig();
        ctxCfg.setDefaultWebXml(TomcatUtil.noDefaultWebXmlPath());
        ctx.addLifecycleListener((LifecycleListener)ctxCfg);
        host.addChild((Container)ctx);
        return server;
    }

    private void checkConfiguration(StandardServer server, Service expectedService, Connector expectedConnector, Engine expectedEngine, StandardHost expectedHost, Context expectedContext) {
        File expectedBaseDir = this.config.baseDir().toFile();
        if (!Objects.equals(server.getCatalinaBase(), expectedBaseDir) || !Objects.equals(server.getCatalinaHome(), expectedBaseDir)) {
            throw new TomcatServiceException("A configurator should never change the Catalina base and home.");
        }
        if (server.getPort() != -2) {
            throw new TomcatServiceException("A configurator should never change the port of the server.");
        }
        Service[] services = server.findServices();
        if (services == null || services.length != 1 || services[0] != expectedService) {
            throw new TomcatServiceException("A configurator should never remove the default service or add a new service.");
        }
        if (!this.config.serviceName().equals(expectedService.getName())) {
            throw new TomcatServiceException("A configurator should never change the name of the default service.");
        }
        Connector[] connectors = expectedService.findConnectors();
        if (connectors == null || Arrays.stream(connectors).noneMatch(c -> c == expectedConnector)) {
            throw new TomcatServiceException("A configurator should never remove the default connector.");
        }
        Engine actualEngine = TomcatUtil.engine(expectedService, expectedHost.getName());
        if (actualEngine != expectedEngine) {
            throw new TomcatServiceException("A configurator should never change the engine of the default service.");
        }
        if (!this.config.engineName().equals(expectedEngine.getName())) {
            throw new TomcatServiceException("A configurator should never change the name of the default engine.");
        }
        if (expectedEngine.getRealm() != this.config.realm()) {
            throw new TomcatServiceException("A configurator should never change the default realm.");
        }
        Container[] engineChildren = expectedEngine.findChildren();
        if (engineChildren == null || Arrays.stream(engineChildren).noneMatch(c -> c == expectedHost)) {
            throw new TomcatServiceException("A configurator should never remove the default host.");
        }
        Container[] contextChildren = expectedHost.findChildren();
        if (contextChildren == null || Arrays.stream(contextChildren).noneMatch(c -> c == expectedContext)) {
            throw new TomcatServiceException("A configurator should never remove the default context.");
        }
        if (!this.config.docBase().toString().equals(expectedContext.getDocBase())) {
            throw new TomcatServiceException("A configurator should never change the docBase of the default context.");
        }
    }

    static {
        System.setProperty("catalina.useNaming", "false");
    }
}

