/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.tomcat;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.internal.server.tomcat.TomcatVersion;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.tomcat.TomcatServiceBuilder;
import com.linecorp.armeria.server.tomcat.TomcatUtil;
import com.linecorp.armeria.server.tomcat.UnmanagedTomcatService;
import io.netty.util.AsciiString;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.util.ServerInfo;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TomcatService
implements HttpService {
    static final Logger logger = LoggerFactory.getLogger(TomcatService.class);
    private static final MethodHandle INPUT_BUFFER_CONSTRUCTOR;
    private static final MethodHandle OUTPUT_BUFFER_CONSTRUCTOR;
    static final Class<?> PROTOCOL_HANDLER_CLASS;
    private static final ResponseHeaders INVALID_AUTHORITY_HEADERS;
    private static final HttpData INVALID_AUTHORITY_DATA;

    public static TomcatService of(File docBase) {
        return TomcatService.builder(docBase).build();
    }

    public static TomcatService of(Path docBase) {
        return TomcatService.builder(docBase).build();
    }

    public static TomcatService of(File rootDir, String relativeDocBase) {
        return TomcatService.builder(rootDir, relativeDocBase).build();
    }

    public static TomcatService of(Path rootDir, String relativeDocBase) {
        return TomcatService.builder(rootDir, relativeDocBase).build();
    }

    public static TomcatService of(Tomcat tomcat) {
        return new UnmanagedTomcatService(Objects.requireNonNull(tomcat, "tomcat"));
    }

    public static TomcatService of(Connector connector) {
        return new UnmanagedTomcatService(Objects.requireNonNull(connector, "connector"), null);
    }

    public static TomcatService of(Connector connector, String hostname) {
        Objects.requireNonNull(connector, "connector");
        Objects.requireNonNull(hostname, "hostname");
        return new UnmanagedTomcatService(connector, hostname);
    }

    public static TomcatServiceBuilder builder(File docBase) {
        return TomcatService.builder(Objects.requireNonNull(docBase, "docBase").toPath());
    }

    public static TomcatServiceBuilder builder(Path docBase) {
        Path absoluteDocBase = Objects.requireNonNull(docBase, "docBase").toAbsolutePath();
        if (TomcatUtil.isZip(absoluteDocBase)) {
            return new TomcatServiceBuilder(absoluteDocBase, "/");
        }
        Preconditions.checkArgument((boolean)Files.isDirectory(absoluteDocBase, new LinkOption[0]), (String)"docBase: %s (expected: a directory, WAR or JAR)", (Object)docBase);
        return new TomcatServiceBuilder(absoluteDocBase, null);
    }

    public static TomcatServiceBuilder builder(File rootDirOrDocBase, String relativePath) {
        return TomcatService.builder(Objects.requireNonNull(rootDirOrDocBase, "rootDirOrDocBase").toPath(), relativePath);
    }

    public static TomcatServiceBuilder builder(Path rootDirOrDocBase, String relativePath) {
        Objects.requireNonNull(rootDirOrDocBase, "rootDirOrDocBase");
        Objects.requireNonNull(relativePath, "relativePath");
        Path absoluteRootDirOrDocBase = rootDirOrDocBase.toAbsolutePath();
        if (TomcatUtil.isZip(absoluteRootDirOrDocBase)) {
            return new TomcatServiceBuilder(absoluteRootDirOrDocBase, TomcatService.normalizeJarRoot(relativePath));
        }
        Preconditions.checkArgument((boolean)Files.isDirectory(absoluteRootDirOrDocBase, new LinkOption[0]), (String)"rootDirOrDocBase: %s (expected: a directory, WAR or JAR)", (Object)rootDirOrDocBase);
        Path rootDir = TomcatService.fileSystemDocBase(rootDirOrDocBase, relativePath);
        Preconditions.checkArgument((boolean)Files.isDirectory(rootDir, new LinkOption[0]), (String)"relativePath: %s (expected: a directory)", (Object)relativePath);
        return new TomcatServiceBuilder(rootDir, null);
    }

    private static String normalizeJarRoot(@Nullable String jarRoot) {
        if (jarRoot == null || jarRoot.isEmpty() || "/".equals(jarRoot)) {
            return "/";
        }
        if (!jarRoot.startsWith("/")) {
            jarRoot = '/' + jarRoot;
        }
        if (jarRoot.endsWith("/")) {
            jarRoot = jarRoot.substring(0, jarRoot.length() - 1);
        }
        return jarRoot;
    }

    private static Path fileSystemDocBase(Path rootDir, String relativePath) {
        String fileSystemDocBase = rootDir.toString();
        relativePath = relativePath.replace('/', File.separatorChar);
        fileSystemDocBase = fileSystemDocBase.endsWith(File.separator) ? (relativePath.startsWith(File.separator) ? fileSystemDocBase + relativePath.substring(1) : fileSystemDocBase + relativePath) : (relativePath.startsWith(File.separator) ? fileSystemDocBase + relativePath : fileSystemDocBase + File.separatorChar + relativePath);
        return Paths.get(fileSystemDocBase, new String[0]);
    }

    static String toString(Server server) {
        Objects.requireNonNull(server, "server");
        Service[] services = server.findServices();
        String serviceName = services.length == 0 ? "<unknown>" : services[0].getName();
        StringBuilder buf = new StringBuilder(128);
        buf.append("(serviceName: ");
        buf.append(serviceName);
        if (TomcatVersion.major() >= 8) {
            buf.append(", catalinaBase: ");
            buf.append(server.getCatalinaBase());
        }
        buf.append(')');
        return buf.toString();
    }

    TomcatService() {
    }

    @Nullable
    public abstract Connector connector();

    @Nullable
    abstract String hostName();

    public final HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Connector connector = this.connector();
        if (connector == null || !TomcatService.isConnectorAvailable(connector.getState())) {
            return HttpResponse.of((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
        }
        Adapter coyoteAdapter = connector.getProtocolHandler().getAdapter();
        if (coyoteAdapter == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE);
        }
        HttpResponseWriter res = HttpResponse.streaming();
        req.aggregate().handle((aReq, cause) -> {
            try {
                if (cause != null) {
                    logger.warn("{} Failed to aggregate a request:", (Object)ctx, cause);
                    if (res.tryWrite((Object)ResponseHeaders.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR))) {
                        res.close();
                    }
                    return null;
                }
                if (!TomcatService.isConnectorAvailable(connector.getState())) {
                    if (res.tryWrite((Object)ResponseHeaders.of((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE))) {
                        res.close();
                    }
                    return null;
                }
                Request coyoteReq = this.convertRequest(ctx, (AggregatedHttpRequest)aReq);
                if (coyoteReq == null) {
                    if (res.tryWrite((Object)INVALID_AUTHORITY_HEADERS) && res.tryWrite((Object)INVALID_AUTHORITY_DATA)) {
                        res.close();
                    }
                    return null;
                }
                Response coyoteRes = new Response();
                coyoteReq.setResponse(coyoteRes);
                coyoteRes.setRequest(coyoteReq);
                ArrayDeque data = new ArrayDeque();
                coyoteRes.setOutputBuffer(OUTPUT_BUFFER_CONSTRUCTOR.invoke(data));
                ctx.blockingTaskExecutor().execute(() -> {
                    block9: {
                        if (!res.isOpen()) {
                            return;
                        }
                        if (!TomcatService.isConnectorAvailable(connector.getState())) {
                            if (res.tryWrite((Object)ResponseHeaders.of((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE))) {
                                res.close();
                            }
                            return;
                        }
                        try {
                            HttpData d;
                            coyoteAdapter.service(coyoteReq, coyoteRes);
                            ResponseHeaders headers = TomcatService.convertResponse(coyoteRes);
                            if (!res.tryWrite((Object)headers)) break block9;
                            while ((d = (HttpData)data.poll()) != null) {
                                if (res.tryWrite((Object)d)) continue;
                                break;
                            }
                        }
                        catch (Throwable t) {
                            logger.warn("{} Failed to produce a response:", (Object)ctx, (Object)t);
                        }
                        finally {
                            res.close();
                        }
                    }
                });
            }
            catch (Throwable t) {
                logger.warn("{} Failed to invoke Tomcat:", (Object)ctx, (Object)t);
                res.close();
            }
            return null;
        });
        return res;
    }

    private static boolean isConnectorAvailable(LifecycleState connectorState) {
        switch (connectorState) {
            case STARTED: 
            case STOPPING_PREP: 
            case STOPPING: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private Request convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest req) throws Throwable {
        String mappedPath = ctx.mappedPath();
        Request coyoteReq = new Request();
        coyoteReq.scheme().setString(req.scheme());
        InetSocketAddress remoteAddr = (InetSocketAddress)ctx.remoteAddress();
        coyoteReq.remoteAddr().setString(remoteAddr.getAddress().getHostAddress());
        coyoteReq.remoteHost().setString(remoteAddr.getHostString());
        coyoteReq.setRemotePort(remoteAddr.getPort());
        InetSocketAddress localAddr = (InetSocketAddress)ctx.localAddress();
        coyoteReq.localAddr().setString(localAddr.getAddress().getHostAddress());
        coyoteReq.localName().setString(this.hostName());
        coyoteReq.setLocalPort(localAddr.getPort());
        String hostHeader = req.authority();
        int colonPos = hostHeader.indexOf(58);
        if (colonPos < 0) {
            coyoteReq.serverName().setString(hostHeader);
        } else {
            coyoteReq.serverName().setString(hostHeader.substring(0, colonPos));
            try {
                int port = Integer.parseInt(hostHeader.substring(colonPos + 1));
                coyoteReq.setServerPort(port);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        coyoteReq.protocol().setString(ctx.sessionProtocol().isMultiplex() ? "HTTP/2.0" : "HTTP/1.1");
        HttpMethod method = req.method();
        coyoteReq.method().setString(method.name());
        byte[] uriBytes = mappedPath.getBytes(StandardCharsets.US_ASCII);
        coyoteReq.requestURI().setBytes(uriBytes, 0, uriBytes.length);
        if (ctx.query() != null) {
            coyoteReq.queryString().setString(ctx.query());
        }
        MimeHeaders cHeaders = coyoteReq.getMimeHeaders();
        TomcatService.convertHeaders((HttpHeaders)req.headers(), cHeaders);
        TomcatService.convertHeaders(req.trailers(), cHeaders);
        HttpData content = req.content();
        coyoteReq.setInputBuffer(INPUT_BUFFER_CONSTRUCTOR.invoke(content));
        return coyoteReq;
    }

    private static void convertHeaders(HttpHeaders headers, MimeHeaders cHeaders) {
        if (headers.isEmpty()) {
            return;
        }
        for (Map.Entry e : headers) {
            AsciiString k = (AsciiString)e.getKey();
            String v = (String)e.getValue();
            if (k.isEmpty() || k.byteAt(0) == 58) continue;
            MessageBytes cValue = cHeaders.addValue(k.array(), k.arrayOffset(), k.length());
            byte[] valueBytes = v.getBytes(StandardCharsets.US_ASCII);
            cValue.setBytes(valueBytes, 0, valueBytes.length);
        }
    }

    private static ResponseHeaders convertResponse(Response coyoteRes) {
        ResponseHeadersBuilder headers = ResponseHeaders.builder();
        headers.status(coyoteRes.getStatus());
        String contentType = coyoteRes.getContentType();
        if (contentType != null && !contentType.isEmpty()) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType);
        }
        long contentLength = coyoteRes.getBytesWritten(true);
        String method = coyoteRes.getRequest().method().toString();
        if (!"HEAD".equals(method)) {
            headers.setLong((CharSequence)HttpHeaderNames.CONTENT_LENGTH, contentLength);
        }
        MimeHeaders cHeaders = coyoteRes.getMimeHeaders();
        int numHeaders = cHeaders.size();
        for (int i = 0; i < numHeaders; ++i) {
            String value;
            AsciiString name = TomcatService.toHeaderName(cHeaders.getName(i));
            if (name == null || (value = TomcatService.toHeaderValue(cHeaders.getValue(i))) == null) continue;
            headers.add((CharSequence)name.toLowerCase(), value);
        }
        return headers.build();
    }

    @Nullable
    private static AsciiString toHeaderName(MessageBytes value) {
        switch (value.getType()) {
            case 2: {
                ByteChunk chunk = value.getByteChunk();
                return new AsciiString(chunk.getBuffer(), chunk.getOffset(), chunk.getLength(), true);
            }
            case 3: {
                CharChunk chunk = value.getCharChunk();
                return new AsciiString(chunk.getBuffer(), chunk.getOffset(), chunk.getLength());
            }
            case 1: {
                return HttpHeaderNames.of((CharSequence)value.getString());
            }
        }
        return null;
    }

    @Nullable
    private static String toHeaderValue(MessageBytes value) {
        switch (value.getType()) {
            case 2: {
                ByteChunk chunk = value.getByteChunk();
                return new String(chunk.getBuffer(), chunk.getOffset(), chunk.getLength(), StandardCharsets.US_ASCII);
            }
            case 3: {
                CharChunk chunk = value.getCharChunk();
                return new String(chunk.getBuffer(), chunk.getOffset(), chunk.getLength());
            }
            case 1: {
                return value.getString();
            }
        }
        return null;
    }

    static {
        String prefix = TomcatVersion.class.getPackage().getName() + '.';
        ClassLoader classLoader = TomcatVersion.class.getClassLoader();
        try {
            Class<?> protocolHandlerClass;
            Class<?> outputBufferClass;
            Class<?> inputBufferClass;
            if (TomcatVersion.major() < 8 || TomcatVersion.major() == 8 && TomcatVersion.minor() < 5) {
                inputBufferClass = Class.forName(prefix + "Tomcat80InputBuffer", true, classLoader);
                outputBufferClass = Class.forName(prefix + "Tomcat80OutputBuffer", true, classLoader);
                protocolHandlerClass = Class.forName(prefix + "Tomcat80ProtocolHandler", true, classLoader);
            } else {
                inputBufferClass = Class.forName(prefix + "Tomcat90InputBuffer", true, classLoader);
                outputBufferClass = Class.forName(prefix + "Tomcat90OutputBuffer", true, classLoader);
                protocolHandlerClass = Class.forName(prefix + "Tomcat90ProtocolHandler", true, classLoader);
            }
            INPUT_BUFFER_CONSTRUCTOR = MethodHandles.lookup().findConstructor(inputBufferClass, MethodType.methodType(Void.TYPE, HttpData.class));
            OUTPUT_BUFFER_CONSTRUCTOR = MethodHandles.lookup().findConstructor(outputBufferClass, MethodType.methodType(Void.TYPE, Queue.class));
            PROTOCOL_HANDLER_CLASS = protocolHandlerClass;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("could not find the matching classes for Tomcat version " + ServerInfo.getServerNumber() + "; using a wrong armeria-tomcat JAR?", e);
        }
        if (TomcatVersion.major() >= 9) {
            try {
                Class<?> initClass = Class.forName(prefix + "ConfigFileLoaderInitializer", true, classLoader);
                MethodHandles.lookup().findStatic(initClass, "init", MethodType.methodType(Void.TYPE)).invoke();
            }
            catch (Throwable cause) {
                logger.debug("Failed to initialize Tomcat ConfigFileLoader.source:", cause);
            }
        }
        INVALID_AUTHORITY_HEADERS = ResponseHeaders.of((HttpStatus)HttpStatus.BAD_REQUEST, (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.PLAIN_TEXT_UTF_8);
        INVALID_AUTHORITY_DATA = HttpData.ofUtf8((String)(HttpStatus.BAD_REQUEST + "\nInvalid authority"));
    }
}

